<?php

namespace EnumType;

/**
 * This class stands for GeneralNetworkManagementTypeEnum EnumType
 * @subpackage Enumerations
 */
class GeneralNetworkManagementTypeEnum
{
    /**
     * Constant for value 'bridgeSwingInOperation'
     * @return string 'bridgeSwingInOperation'
     */
    const VALUE_BRIDGE_SWING_IN_OPERATION = 'bridgeSwingInOperation';
    /**
     * Constant for value 'convoyService'
     * @return string 'convoyService'
     */
    const VALUE_CONVOY_SERVICE = 'convoyService';
    /**
     * Constant for value 'obstacleSignalling'
     * @return string 'obstacleSignalling'
     */
    const VALUE_OBSTACLE_SIGNALLING = 'obstacleSignalling';
    /**
     * Constant for value 'rampMeteringInOperation'
     * @return string 'rampMeteringInOperation'
     */
    const VALUE_RAMP_METERING_IN_OPERATION = 'rampMeteringInOperation';
    /**
     * Constant for value 'temporaryTrafficLights'
     * @return string 'temporaryTrafficLights'
     */
    const VALUE_TEMPORARY_TRAFFIC_LIGHTS = 'temporaryTrafficLights';
    /**
     * Constant for value 'tollGatesOpen'
     * @return string 'tollGatesOpen'
     */
    const VALUE_TOLL_GATES_OPEN = 'tollGatesOpen';
    /**
     * Constant for value 'trafficBeingManuallyDirected'
     * @return string 'trafficBeingManuallyDirected'
     */
    const VALUE_TRAFFIC_BEING_MANUALLY_DIRECTED = 'trafficBeingManuallyDirected';
    /**
     * Constant for value 'trafficHeld'
     * @return string 'trafficHeld'
     */
    const VALUE_TRAFFIC_HELD = 'trafficHeld';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BRIDGE_SWING_IN_OPERATION
     * @uses self::VALUE_CONVOY_SERVICE
     * @uses self::VALUE_OBSTACLE_SIGNALLING
     * @uses self::VALUE_RAMP_METERING_IN_OPERATION
     * @uses self::VALUE_TEMPORARY_TRAFFIC_LIGHTS
     * @uses self::VALUE_TOLL_GATES_OPEN
     * @uses self::VALUE_TRAFFIC_BEING_MANUALLY_DIRECTED
     * @uses self::VALUE_TRAFFIC_HELD
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BRIDGE_SWING_IN_OPERATION,
            self::VALUE_CONVOY_SERVICE,
            self::VALUE_OBSTACLE_SIGNALLING,
            self::VALUE_RAMP_METERING_IN_OPERATION,
            self::VALUE_TEMPORARY_TRAFFIC_LIGHTS,
            self::VALUE_TOLL_GATES_OPEN,
            self::VALUE_TRAFFIC_BEING_MANUALLY_DIRECTED,
            self::VALUE_TRAFFIC_HELD,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
