<?php

namespace EnumType;

/**
 * This class stands for FunicularSubmodesOfTransportEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Funicular ModesOfTransport: TPEG pti_table_10.
 * @subpackage Enumerations
 */
class FunicularSubmodesOfTransportEnumeration
{
    /**
     * Constant for value 'pti10_0'
     * @return string 'pti10_0'
     */
    const VALUE_PTI_10_0 = 'pti10_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti10_1'
     * @return string 'pti10_1'
     */
    const VALUE_PTI_10_1 = 'pti10_1';
    /**
     * Constant for value 'loc14_2'
     * @return string 'loc14_2'
     */
    const VALUE_LOC_14_2 = 'loc14_2';
    /**
     * Constant for value 'funicular'
     * @return string 'funicular'
     */
    const VALUE_FUNICULAR = 'funicular';
    /**
     * Constant for value 'pti10_2'
     * @return string 'pti10_2'
     */
    const VALUE_PTI_10_2 = 'pti10_2';
    /**
     * Constant for value 'allFunicularServices'
     * @return string 'allFunicularServices'
     */
    const VALUE_ALL_FUNICULAR_SERVICES = 'allFunicularServices';
    /**
     * Constant for value 'pti10_255'
     * @return string 'pti10_255'
     */
    const VALUE_PTI_10_255 = 'pti10_255';
    /**
     * Constant for value 'undefinedFunicular'
     * @return string 'undefinedFunicular'
     */
    const VALUE_UNDEFINED_FUNICULAR = 'undefinedFunicular';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_10_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_10_1
     * @uses self::VALUE_LOC_14_2
     * @uses self::VALUE_FUNICULAR
     * @uses self::VALUE_PTI_10_2
     * @uses self::VALUE_ALL_FUNICULAR_SERVICES
     * @uses self::VALUE_PTI_10_255
     * @uses self::VALUE_UNDEFINED_FUNICULAR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_10_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_10_1,
            self::VALUE_LOC_14_2,
            self::VALUE_FUNICULAR,
            self::VALUE_PTI_10_2,
            self::VALUE_ALL_FUNICULAR_SERVICES,
            self::VALUE_PTI_10_255,
            self::VALUE_UNDEFINED_FUNICULAR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
