<?php

namespace EnumType;

/**
 * This class stands for FacilityStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for the status of a MONITORED FACILITY.
 * @subpackage Enumerations
 */
class FacilityStatusEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'available'
     * @return string 'available'
     */
    const VALUE_AVAILABLE = 'available';
    /**
     * Constant for value 'notAvailable'
     * @return string 'notAvailable'
     */
    const VALUE_NOT_AVAILABLE = 'notAvailable';
    /**
     * Constant for value 'partiallyAvailable'
     * @return string 'partiallyAvailable'
     */
    const VALUE_PARTIALLY_AVAILABLE = 'partiallyAvailable';
    /**
     * Constant for value 'added'
     * @return string 'added'
     */
    const VALUE_ADDED = 'added';
    /**
     * Constant for value 'removed'
     * @return string 'removed'
     */
    const VALUE_REMOVED = 'removed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_NOT_AVAILABLE
     * @uses self::VALUE_PARTIALLY_AVAILABLE
     * @uses self::VALUE_ADDED
     * @uses self::VALUE_REMOVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_AVAILABLE,
            self::VALUE_NOT_AVAILABLE,
            self::VALUE_PARTIALLY_AVAILABLE,
            self::VALUE_ADDED,
            self::VALUE_REMOVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
