<?php

namespace EnumType;

/**
 * This class stands for FacilityStatusChangeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for changes to the status of a facility.
 * @subpackage Enumerations
 */
class FacilityStatusChangeEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'added'
     * @return string 'added'
     */
    const VALUE_ADDED = 'added';
    /**
     * Constant for value 'removed'
     * @return string 'removed'
     */
    const VALUE_REMOVED = 'removed';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_ADDED
     * @uses self::VALUE_REMOVED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_ADDED,
            self::VALUE_REMOVED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
