<?php

namespace EnumType;

/**
 * This class stands for EnvironmentSubReasonEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Environment incident subreason types.
 * @subpackage Enumerations
 */
class EnvironmentSubReasonEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'fog'
     * @return string 'fog'
     */
    const VALUE_FOG = 'fog';
    /**
     * Constant for value 'roughSea'
     * @return string 'roughSea'
     */
    const VALUE_ROUGH_SEA = 'roughSea';
    /**
     * Constant for value 'heavySnowFall'
     * @return string 'heavySnowFall'
     */
    const VALUE_HEAVY_SNOW_FALL = 'heavySnowFall';
    /**
     * Constant for value 'driftingSnow'
     * @return string 'driftingSnow'
     */
    const VALUE_DRIFTING_SNOW = 'driftingSnow';
    /**
     * Constant for value 'heavyRain'
     * @return string 'heavyRain'
     */
    const VALUE_HEAVY_RAIN = 'heavyRain';
    /**
     * Constant for value 'blizzardConditions'
     * @return string 'blizzardConditions'
     */
    const VALUE_BLIZZARD_CONDITIONS = 'blizzardConditions';
    /**
     * Constant for value 'strongWinds'
     * @return string 'strongWinds'
     */
    const VALUE_STRONG_WINDS = 'strongWinds';
    /**
     * Constant for value 'stormConditions'
     * @return string 'stormConditions'
     */
    const VALUE_STORM_CONDITIONS = 'stormConditions';
    /**
     * Constant for value 'stormDamage'
     * @return string 'stormDamage'
     */
    const VALUE_STORM_DAMAGE = 'stormDamage';
    /**
     * Constant for value 'tidalRestrictions'
     * @return string 'tidalRestrictions'
     */
    const VALUE_TIDAL_RESTRICTIONS = 'tidalRestrictions';
    /**
     * Constant for value 'highTide'
     * @return string 'highTide'
     */
    const VALUE_HIGH_TIDE = 'highTide';
    /**
     * Constant for value 'lowTide'
     * @return string 'lowTide'
     */
    const VALUE_LOW_TIDE = 'lowTide';
    /**
     * Constant for value 'ice'
     * @return string 'ice'
     */
    const VALUE_ICE = 'ice';
    /**
     * Constant for value 'slipperiness'
     * @return string 'slipperiness'
     */
    const VALUE_SLIPPERINESS = 'slipperiness';
    /**
     * Constant for value 'iceDrift'
     * @return string 'iceDrift'
     */
    const VALUE_ICE_DRIFT = 'iceDrift';
    /**
     * Constant for value 'glazedFrost'
     * @return string 'glazedFrost'
     */
    const VALUE_GLAZED_FROST = 'glazedFrost';
    /**
     * Constant for value 'frozen'
     * @return string 'frozen'
     */
    const VALUE_FROZEN = 'frozen';
    /**
     * Constant for value 'hail'
     * @return string 'hail'
     */
    const VALUE_HAIL = 'hail';
    /**
     * Constant for value 'sleet'
     * @return string 'sleet'
     */
    const VALUE_SLEET = 'sleet';
    /**
     * Constant for value 'highTemperatures'
     * @return string 'highTemperatures'
     */
    const VALUE_HIGH_TEMPERATURES = 'highTemperatures';
    /**
     * Constant for value 'flooding'
     * @return string 'flooding'
     */
    const VALUE_FLOODING = 'flooding';
    /**
     * Constant for value 'waterlogged'
     * @return string 'waterlogged'
     */
    const VALUE_WATERLOGGED = 'waterlogged';
    /**
     * Constant for value 'lowWaterLevel'
     * @return string 'lowWaterLevel'
     */
    const VALUE_LOW_WATER_LEVEL = 'lowWaterLevel';
    /**
     * Constant for value 'highWaterLevel'
     * @return string 'highWaterLevel'
     */
    const VALUE_HIGH_WATER_LEVEL = 'highWaterLevel';
    /**
     * Constant for value 'fallenLeaves'
     * @return string 'fallenLeaves'
     */
    const VALUE_FALLEN_LEAVES = 'fallenLeaves';
    /**
     * Constant for value 'fallenTree'
     * @return string 'fallenTree'
     */
    const VALUE_FALLEN_TREE = 'fallenTree';
    /**
     * Constant for value 'landslide'
     * @return string 'landslide'
     */
    const VALUE_LANDSLIDE = 'landslide';
    /**
     * Constant for value 'undefinedEnvironmentalProblem'
     * @return string 'undefinedEnvironmentalProblem'
     */
    const VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM = 'undefinedEnvironmentalProblem';
    /**
     * Constant for value 'sewerOverflow'
     * @return string 'sewerOverflow'
     */
    const VALUE_SEWER_OVERFLOW = 'sewerOverflow';
    /**
     * Constant for value 'grassFire'
     * @return string 'grassFire'
     */
    const VALUE_GRASS_FIRE = 'grassFire';
    /**
     * Constant for value 'lighteningStrike'
     * @return string 'lighteningStrike'
     */
    const VALUE_LIGHTENING_STRIKE = 'lighteningStrike';
    /**
     * Constant for value 'avalanches'
     * @return string 'avalanches'
     */
    const VALUE_AVALANCHES = 'avalanches';
    /**
     * Constant for value 'flashFloods'
     * @return string 'flashFloods'
     */
    const VALUE_FLASH_FLOODS = 'flashFloods';
    /**
     * Constant for value 'mudslip'
     * @return string 'mudslip'
     */
    const VALUE_MUDSLIP = 'mudslip';
    /**
     * Constant for value 'rockfalls'
     * @return string 'rockfalls'
     */
    const VALUE_ROCKFALLS = 'rockfalls';
    /**
     * Constant for value 'subsidence'
     * @return string 'subsidence'
     */
    const VALUE_SUBSIDENCE = 'subsidence';
    /**
     * Constant for value 'earthquakeDamage'
     * @return string 'earthquakeDamage'
     */
    const VALUE_EARTHQUAKE_DAMAGE = 'earthquakeDamage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_FOG
     * @uses self::VALUE_ROUGH_SEA
     * @uses self::VALUE_HEAVY_SNOW_FALL
     * @uses self::VALUE_DRIFTING_SNOW
     * @uses self::VALUE_HEAVY_RAIN
     * @uses self::VALUE_BLIZZARD_CONDITIONS
     * @uses self::VALUE_STRONG_WINDS
     * @uses self::VALUE_STORM_CONDITIONS
     * @uses self::VALUE_STORM_DAMAGE
     * @uses self::VALUE_TIDAL_RESTRICTIONS
     * @uses self::VALUE_HIGH_TIDE
     * @uses self::VALUE_LOW_TIDE
     * @uses self::VALUE_ICE
     * @uses self::VALUE_SLIPPERINESS
     * @uses self::VALUE_ICE_DRIFT
     * @uses self::VALUE_GLAZED_FROST
     * @uses self::VALUE_FROZEN
     * @uses self::VALUE_HAIL
     * @uses self::VALUE_SLEET
     * @uses self::VALUE_HIGH_TEMPERATURES
     * @uses self::VALUE_FLOODING
     * @uses self::VALUE_WATERLOGGED
     * @uses self::VALUE_LOW_WATER_LEVEL
     * @uses self::VALUE_HIGH_WATER_LEVEL
     * @uses self::VALUE_FALLEN_LEAVES
     * @uses self::VALUE_FALLEN_TREE
     * @uses self::VALUE_LANDSLIDE
     * @uses self::VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM
     * @uses self::VALUE_SEWER_OVERFLOW
     * @uses self::VALUE_GRASS_FIRE
     * @uses self::VALUE_LIGHTENING_STRIKE
     * @uses self::VALUE_AVALANCHES
     * @uses self::VALUE_FLASH_FLOODS
     * @uses self::VALUE_MUDSLIP
     * @uses self::VALUE_ROCKFALLS
     * @uses self::VALUE_SUBSIDENCE
     * @uses self::VALUE_EARTHQUAKE_DAMAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_FOG,
            self::VALUE_ROUGH_SEA,
            self::VALUE_HEAVY_SNOW_FALL,
            self::VALUE_DRIFTING_SNOW,
            self::VALUE_HEAVY_RAIN,
            self::VALUE_BLIZZARD_CONDITIONS,
            self::VALUE_STRONG_WINDS,
            self::VALUE_STORM_CONDITIONS,
            self::VALUE_STORM_DAMAGE,
            self::VALUE_TIDAL_RESTRICTIONS,
            self::VALUE_HIGH_TIDE,
            self::VALUE_LOW_TIDE,
            self::VALUE_ICE,
            self::VALUE_SLIPPERINESS,
            self::VALUE_ICE_DRIFT,
            self::VALUE_GLAZED_FROST,
            self::VALUE_FROZEN,
            self::VALUE_HAIL,
            self::VALUE_SLEET,
            self::VALUE_HIGH_TEMPERATURES,
            self::VALUE_FLOODING,
            self::VALUE_WATERLOGGED,
            self::VALUE_LOW_WATER_LEVEL,
            self::VALUE_HIGH_WATER_LEVEL,
            self::VALUE_FALLEN_LEAVES,
            self::VALUE_FALLEN_TREE,
            self::VALUE_LANDSLIDE,
            self::VALUE_UNDEFINED_ENVIRONMENTAL_PROBLEM,
            self::VALUE_SEWER_OVERFLOW,
            self::VALUE_GRASS_FIRE,
            self::VALUE_LIGHTENING_STRIKE,
            self::VALUE_AVALANCHES,
            self::VALUE_FLASH_FLOODS,
            self::VALUE_MUDSLIP,
            self::VALUE_ROCKFALLS,
            self::VALUE_SUBSIDENCE,
            self::VALUE_EARTHQUAKE_DAMAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
