<?php

namespace EnumType;

/**
 * This class stands for EncumbranceEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of specific encumbrances USER NEEDs.
 * @subpackage Enumerations
 */
class EncumbranceEnumeration
{
    /**
     * Constant for value 'luggageEncumbered'
     * @return string 'luggageEncumbered'
     */
    const VALUE_LUGGAGE_ENCUMBERED = 'luggageEncumbered';
    /**
     * Constant for value 'pushchair'
     * @return string 'pushchair'
     */
    const VALUE_PUSHCHAIR = 'pushchair';
    /**
     * Constant for value 'baggageTrolley'
     * @return string 'baggageTrolley'
     */
    const VALUE_BAGGAGE_TROLLEY = 'baggageTrolley';
    /**
     * Constant for value 'oversizeBaggage'
     * @return string 'oversizeBaggage'
     */
    const VALUE_OVERSIZE_BAGGAGE = 'oversizeBaggage';
    /**
     * Constant for value 'guideDog'
     * @return string 'guideDog'
     */
    const VALUE_GUIDE_DOG = 'guideDog';
    /**
     * Constant for value 'otherAnimal'
     * @return string 'otherAnimal'
     */
    const VALUE_OTHER_ANIMAL = 'otherAnimal';
    /**
     * Constant for value 'otherEncumbrance'
     * @return string 'otherEncumbrance'
     */
    const VALUE_OTHER_ENCUMBRANCE = 'otherEncumbrance';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_LUGGAGE_ENCUMBERED
     * @uses self::VALUE_PUSHCHAIR
     * @uses self::VALUE_BAGGAGE_TROLLEY
     * @uses self::VALUE_OVERSIZE_BAGGAGE
     * @uses self::VALUE_GUIDE_DOG
     * @uses self::VALUE_OTHER_ANIMAL
     * @uses self::VALUE_OTHER_ENCUMBRANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_LUGGAGE_ENCUMBERED,
            self::VALUE_PUSHCHAIR,
            self::VALUE_BAGGAGE_TROLLEY,
            self::VALUE_OVERSIZE_BAGGAGE,
            self::VALUE_GUIDE_DOG,
            self::VALUE_OTHER_ANIMAL,
            self::VALUE_OTHER_ENCUMBRANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
