<?php

namespace EnumType;

/**
 * This class stands for DirectionEnum EnumType
 * @subpackage Enumerations
 */
class DirectionEnum
{
    /**
     * Constant for value 'anticlockwise'
     * @return string 'anticlockwise'
     */
    const VALUE_ANTICLOCKWISE = 'anticlockwise';
    /**
     * Constant for value 'clockwise'
     * @return string 'clockwise'
     */
    const VALUE_CLOCKWISE = 'clockwise';
    /**
     * Constant for value 'northBound'
     * @return string 'northBound'
     */
    const VALUE_NORTH_BOUND = 'northBound';
    /**
     * Constant for value 'northEastBound'
     * @return string 'northEastBound'
     */
    const VALUE_NORTH_EAST_BOUND = 'northEastBound';
    /**
     * Constant for value 'eastBound'
     * @return string 'eastBound'
     */
    const VALUE_EAST_BOUND = 'eastBound';
    /**
     * Constant for value 'southEastBound'
     * @return string 'southEastBound'
     */
    const VALUE_SOUTH_EAST_BOUND = 'southEastBound';
    /**
     * Constant for value 'southBound'
     * @return string 'southBound'
     */
    const VALUE_SOUTH_BOUND = 'southBound';
    /**
     * Constant for value 'southWestBound'
     * @return string 'southWestBound'
     */
    const VALUE_SOUTH_WEST_BOUND = 'southWestBound';
    /**
     * Constant for value 'westBound'
     * @return string 'westBound'
     */
    const VALUE_WEST_BOUND = 'westBound';
    /**
     * Constant for value 'northWestBound'
     * @return string 'northWestBound'
     */
    const VALUE_NORTH_WEST_BOUND = 'northWestBound';
    /**
     * Constant for value 'inboundTowardsTown'
     * @return string 'inboundTowardsTown'
     */
    const VALUE_INBOUND_TOWARDS_TOWN = 'inboundTowardsTown';
    /**
     * Constant for value 'outboundFromTown'
     * @return string 'outboundFromTown'
     */
    const VALUE_OUTBOUND_FROM_TOWN = 'outboundFromTown';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ANTICLOCKWISE
     * @uses self::VALUE_CLOCKWISE
     * @uses self::VALUE_NORTH_BOUND
     * @uses self::VALUE_NORTH_EAST_BOUND
     * @uses self::VALUE_EAST_BOUND
     * @uses self::VALUE_SOUTH_EAST_BOUND
     * @uses self::VALUE_SOUTH_BOUND
     * @uses self::VALUE_SOUTH_WEST_BOUND
     * @uses self::VALUE_WEST_BOUND
     * @uses self::VALUE_NORTH_WEST_BOUND
     * @uses self::VALUE_INBOUND_TOWARDS_TOWN
     * @uses self::VALUE_OUTBOUND_FROM_TOWN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ANTICLOCKWISE,
            self::VALUE_CLOCKWISE,
            self::VALUE_NORTH_BOUND,
            self::VALUE_NORTH_EAST_BOUND,
            self::VALUE_EAST_BOUND,
            self::VALUE_SOUTH_EAST_BOUND,
            self::VALUE_SOUTH_BOUND,
            self::VALUE_SOUTH_WEST_BOUND,
            self::VALUE_WEST_BOUND,
            self::VALUE_NORTH_WEST_BOUND,
            self::VALUE_INBOUND_TOWARDS_TOWN,
            self::VALUE_OUTBOUND_FROM_TOWN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
