<?php

namespace EnumType;

/**
 * This class stands for DepartureBoardingActivityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed types activity for Boarding.
 * @subpackage Enumerations
 */
class DepartureBoardingActivityEnumeration
{
    /**
     * Constant for value 'boarding'
     * @return string 'boarding'
     */
    const VALUE_BOARDING = 'boarding';
    /**
     * Constant for value 'noBoarding'
     * @return string 'noBoarding'
     */
    const VALUE_NO_BOARDING = 'noBoarding';
    /**
     * Constant for value 'passThru'
     * @return string 'passThru'
     */
    const VALUE_PASS_THRU = 'passThru';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BOARDING
     * @uses self::VALUE_NO_BOARDING
     * @uses self::VALUE_PASS_THRU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BOARDING,
            self::VALUE_NO_BOARDING,
            self::VALUE_PASS_THRU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
