<?php

namespace EnumType;

/**
 * This class stands for DenyReasonEnum EnumType
 * @subpackage Enumerations
 */
class DenyReasonEnum
{
    /**
     * Constant for value 'unknownReason'
     * @return string 'unknownReason'
     */
    const VALUE_UNKNOWN_REASON = 'unknownReason';
    /**
     * Constant for value 'wrongCatalogue'
     * @return string 'wrongCatalogue'
     */
    const VALUE_WRONG_CATALOGUE = 'wrongCatalogue';
    /**
     * Constant for value 'wrongFilter'
     * @return string 'wrongFilter'
     */
    const VALUE_WRONG_FILTER = 'wrongFilter';
    /**
     * Constant for value 'wrongOrder'
     * @return string 'wrongOrder'
     */
    const VALUE_WRONG_ORDER = 'wrongOrder';
    /**
     * Constant for value 'wrongPartner'
     * @return string 'wrongPartner'
     */
    const VALUE_WRONG_PARTNER = 'wrongPartner';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN_REASON
     * @uses self::VALUE_WRONG_CATALOGUE
     * @uses self::VALUE_WRONG_FILTER
     * @uses self::VALUE_WRONG_ORDER
     * @uses self::VALUE_WRONG_PARTNER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN_REASON,
            self::VALUE_WRONG_CATALOGUE,
            self::VALUE_WRONG_FILTER,
            self::VALUE_WRONG_ORDER,
            self::VALUE_WRONG_PARTNER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
