<?php

namespace EnumType;

/**
 * This class stands for DelaysTypeEnum EnumType
 * @subpackage Enumerations
 */
class DelaysTypeEnum
{
    /**
     * Constant for value 'delays'
     * @return string 'delays'
     */
    const VALUE_DELAYS = 'delays';
    /**
     * Constant for value 'delaysOfUncertainDuration'
     * @return string 'delaysOfUncertainDuration'
     */
    const VALUE_DELAYS_OF_UNCERTAIN_DURATION = 'delaysOfUncertainDuration';
    /**
     * Constant for value 'longDelays'
     * @return string 'longDelays'
     */
    const VALUE_LONG_DELAYS = 'longDelays';
    /**
     * Constant for value 'veryLongDelays'
     * @return string 'veryLongDelays'
     */
    const VALUE_VERY_LONG_DELAYS = 'veryLongDelays';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_DELAYS
     * @uses self::VALUE_DELAYS_OF_UNCERTAIN_DURATION
     * @uses self::VALUE_LONG_DELAYS
     * @uses self::VALUE_VERY_LONG_DELAYS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_DELAYS,
            self::VALUE_DELAYS_OF_UNCERTAIN_DURATION,
            self::VALUE_LONG_DELAYS,
            self::VALUE_VERY_LONG_DELAYS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
