<?php

namespace EnumType;

/**
 * This class stands for DaysOfWeekEnumerationx EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Day Type TPEG pti_table 34
 * @subpackage Enumerations
 */
class DaysOfWeekEnumerationx
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'monday'
     * @return string 'monday'
     */
    const VALUE_MONDAY = 'monday';
    /**
     * Constant for value 'tuesday'
     * @return string 'tuesday'
     */
    const VALUE_TUESDAY = 'tuesday';
    /**
     * Constant for value 'wednesday'
     * @return string 'wednesday'
     */
    const VALUE_WEDNESDAY = 'wednesday';
    /**
     * Constant for value 'thursday'
     * @return string 'thursday'
     */
    const VALUE_THURSDAY = 'thursday';
    /**
     * Constant for value 'friday'
     * @return string 'friday'
     */
    const VALUE_FRIDAY = 'friday';
    /**
     * Constant for value 'saturday'
     * @return string 'saturday'
     */
    const VALUE_SATURDAY = 'saturday';
    /**
     * Constant for value 'sunday'
     * @return string 'sunday'
     */
    const VALUE_SUNDAY = 'sunday';
    /**
     * Constant for value 'mondayToFriday'
     * @return string 'mondayToFriday'
     */
    const VALUE_MONDAY_TO_FRIDAY = 'mondayToFriday';
    /**
     * Constant for value 'mondayToSaturday'
     * @return string 'mondayToSaturday'
     */
    const VALUE_MONDAY_TO_SATURDAY = 'mondayToSaturday';
    /**
     * Constant for value 'weekdays'
     * @return string 'weekdays'
     */
    const VALUE_WEEKDAYS = 'weekdays';
    /**
     * Constant for value 'weekends'
     * @return string 'weekends'
     */
    const VALUE_WEEKENDS = 'weekends';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_MONDAY
     * @uses self::VALUE_TUESDAY
     * @uses self::VALUE_WEDNESDAY
     * @uses self::VALUE_THURSDAY
     * @uses self::VALUE_FRIDAY
     * @uses self::VALUE_SATURDAY
     * @uses self::VALUE_SUNDAY
     * @uses self::VALUE_MONDAY_TO_FRIDAY
     * @uses self::VALUE_MONDAY_TO_SATURDAY
     * @uses self::VALUE_WEEKDAYS
     * @uses self::VALUE_WEEKENDS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_MONDAY,
            self::VALUE_TUESDAY,
            self::VALUE_WEDNESDAY,
            self::VALUE_THURSDAY,
            self::VALUE_FRIDAY,
            self::VALUE_SATURDAY,
            self::VALUE_SUNDAY,
            self::VALUE_MONDAY_TO_FRIDAY,
            self::VALUE_MONDAY_TO_SATURDAY,
            self::VALUE_WEEKDAYS,
            self::VALUE_WEEKENDS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
