<?php

namespace EnumType;

/**
 * This class stands for DayEnum EnumType
 * @subpackage Enumerations
 */
class DayEnum
{
    /**
     * Constant for value 'monday'
     * @return string 'monday'
     */
    const VALUE_MONDAY = 'monday';
    /**
     * Constant for value 'tuesday'
     * @return string 'tuesday'
     */
    const VALUE_TUESDAY = 'tuesday';
    /**
     * Constant for value 'wednesday'
     * @return string 'wednesday'
     */
    const VALUE_WEDNESDAY = 'wednesday';
    /**
     * Constant for value 'thursday'
     * @return string 'thursday'
     */
    const VALUE_THURSDAY = 'thursday';
    /**
     * Constant for value 'friday'
     * @return string 'friday'
     */
    const VALUE_FRIDAY = 'friday';
    /**
     * Constant for value 'saturday'
     * @return string 'saturday'
     */
    const VALUE_SATURDAY = 'saturday';
    /**
     * Constant for value 'sunday'
     * @return string 'sunday'
     */
    const VALUE_SUNDAY = 'sunday';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_MONDAY
     * @uses self::VALUE_TUESDAY
     * @uses self::VALUE_WEDNESDAY
     * @uses self::VALUE_THURSDAY
     * @uses self::VALUE_FRIDAY
     * @uses self::VALUE_SATURDAY
     * @uses self::VALUE_SUNDAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_MONDAY,
            self::VALUE_TUESDAY,
            self::VALUE_WEDNESDAY,
            self::VALUE_THURSDAY,
            self::VALUE_FRIDAY,
            self::VALUE_SATURDAY,
            self::VALUE_SUNDAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
