<?php

namespace EnumType;

/**
 * This class stands for ConstructionWorkTypeEnum EnumType
 * @subpackage Enumerations
 */
class ConstructionWorkTypeEnum
{
    /**
     * Constant for value 'blastingWork'
     * @return string 'blastingWork'
     */
    const VALUE_BLASTING_WORK = 'blastingWork';
    /**
     * Constant for value 'constructionWork'
     * @return string 'constructionWork'
     */
    const VALUE_CONSTRUCTION_WORK = 'constructionWork';
    /**
     * Constant for value 'demolitionWork'
     * @return string 'demolitionWork'
     */
    const VALUE_DEMOLITION_WORK = 'demolitionWork';
    /**
     * Constant for value 'roadWideningWork'
     * @return string 'roadWideningWork'
     */
    const VALUE_ROAD_WIDENING_WORK = 'roadWideningWork';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BLASTING_WORK
     * @uses self::VALUE_CONSTRUCTION_WORK
     * @uses self::VALUE_DEMOLITION_WORK
     * @uses self::VALUE_ROAD_WIDENING_WORK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BLASTING_WORK,
            self::VALUE_CONSTRUCTION_WORK,
            self::VALUE_DEMOLITION_WORK,
            self::VALUE_ROAD_WIDENING_WORK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
