<?php

namespace EnumType;

/**
 * This class stands for ConnectionDirectionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for DIRECTION of CONNECTION link or SERVCIE JOURNEY INTERCHANGE.
 * @subpackage Enumerations
 */
class ConnectionDirectionEnumeration
{
    /**
     * Constant for value 'to'
     * @return string 'to'
     */
    const VALUE_TO = 'to';
    /**
     * Constant for value 'from'
     * @return string 'from'
     */
    const VALUE_FROM = 'from';
    /**
     * Constant for value 'both'
     * @return string 'both'
     */
    const VALUE_BOTH = 'both';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TO
     * @uses self::VALUE_FROM
     * @uses self::VALUE_BOTH
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TO,
            self::VALUE_FROM,
            self::VALUE_BOTH,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
