<?php

namespace EnumType;

/**
 * This class stands for CongestionEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for a CHECK CONSTRAINT.
 * @subpackage Enumerations
 */
class CongestionEnumeration
{
    /**
     * Constant for value 'noWaiting'
     * @return string 'noWaiting'
     */
    const VALUE_NO_WAITING = 'noWaiting';
    /**
     * Constant for value 'queue'
     * @return string 'queue'
     */
    const VALUE_QUEUE = 'queue';
    /**
     * Constant for value 'crowding'
     * @return string 'crowding'
     */
    const VALUE_CROWDING = 'crowding';
    /**
     * Constant for value 'full'
     * @return string 'full'
     */
    const VALUE_FULL = 'full';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NO_WAITING
     * @uses self::VALUE_QUEUE
     * @uses self::VALUE_CROWDING
     * @uses self::VALUE_FULL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NO_WAITING,
            self::VALUE_QUEUE,
            self::VALUE_CROWDING,
            self::VALUE_FULL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
