<?php

namespace EnumType;

/**
 * This class stands for CommunicationsTransportMethodEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of communications transport method usage.
 * @subpackage Enumerations
 */
class CommunicationsTransportMethodEnumeration
{
    /**
     * Constant for value 'httpPost'
     * @return string 'httpPost'
     */
    const VALUE_HTTP_POST = 'httpPost';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Constant for value 'wsdlSoap'
     * @return string 'wsdlSoap'
     */
    const VALUE_WSDL_SOAP = 'wsdlSoap';
    /**
     * Constant for value 'wsdlSoapDocumentLiteral'
     * @return string 'wsdlSoapDocumentLiteral'
     */
    const VALUE_WSDL_SOAP_DOCUMENT_LITERAL = 'wsdlSoapDocumentLiteral';
    /**
     * Constant for value 'httpUrlJSON'
     * @return string 'httpUrlJSON'
     */
    const VALUE_HTTP_URL_JSON = 'httpUrlJSON';
    /**
     * Constant for value 'httpUrlProtoBuffers'
     * @return string 'httpUrlProtoBuffers'
     */
    const VALUE_HTTP_URL_PROTO_BUFFERS = 'httpUrlProtoBuffers';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_HTTP_POST
     * @uses self::VALUE_OTHER
     * @uses self::VALUE_WSDL_SOAP
     * @uses self::VALUE_WSDL_SOAP_DOCUMENT_LITERAL
     * @uses self::VALUE_HTTP_URL_JSON
     * @uses self::VALUE_HTTP_URL_PROTO_BUFFERS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_HTTP_POST,
            self::VALUE_OTHER,
            self::VALUE_WSDL_SOAP,
            self::VALUE_WSDL_SOAP_DOCUMENT_LITERAL,
            self::VALUE_HTTP_URL_JSON,
            self::VALUE_HTTP_URL_PROTO_BUFFERS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
