<?php

namespace EnumType;

/**
 * This class stands for CheckPointServiceEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Allowed values for a CHECK CONSTRAINT.
 * @subpackage Enumerations
 */
class CheckPointServiceEnumeration
{
    /**
     * Constant for value 'selfserviceMachine'
     * @return string 'selfserviceMachine'
     */
    const VALUE_SELFSERVICE_MACHINE = 'selfserviceMachine';
    /**
     * Constant for value 'counterService'
     * @return string 'counterService'
     */
    const VALUE_COUNTER_SERVICE = 'counterService';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SELFSERVICE_MACHINE
     * @uses self::VALUE_COUNTER_SERVICE
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SELFSERVICE_MACHINE,
            self::VALUE_COUNTER_SERVICE,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
