<?php

namespace EnumType;

/**
 * This class stands for ChangedFlagEnum EnumType
 * @subpackage Enumerations
 */
class ChangedFlagEnum
{
    /**
     * Constant for value 'catalogue'
     * @return string 'catalogue'
     */
    const VALUE_CATALOGUE = 'catalogue';
    /**
     * Constant for value 'filter'
     * @return string 'filter'
     */
    const VALUE_FILTER = 'filter';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CATALOGUE
     * @uses self::VALUE_FILTER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CATALOGUE,
            self::VALUE_FILTER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
