<?php

namespace EnumType;

/**
 * This class stands for CauseTypeEnum EnumType
 * @subpackage Enumerations
 */
class CauseTypeEnum
{
    /**
     * Constant for value 'accident'
     * @return string 'accident'
     */
    const VALUE_ACCIDENT = 'accident';
    /**
     * Constant for value 'congestion'
     * @return string 'congestion'
     */
    const VALUE_CONGESTION = 'congestion';
    /**
     * Constant for value 'earlierAccident'
     * @return string 'earlierAccident'
     */
    const VALUE_EARLIER_ACCIDENT = 'earlierAccident';
    /**
     * Constant for value 'earlierEvent'
     * @return string 'earlierEvent'
     */
    const VALUE_EARLIER_EVENT = 'earlierEvent';
    /**
     * Constant for value 'earlierIncident'
     * @return string 'earlierIncident'
     */
    const VALUE_EARLIER_INCIDENT = 'earlierIncident';
    /**
     * Constant for value 'equipmentFailure'
     * @return string 'equipmentFailure'
     */
    const VALUE_EQUIPMENT_FAILURE = 'equipmentFailure';
    /**
     * Constant for value 'excessiveHeat'
     * @return string 'excessiveHeat'
     */
    const VALUE_EXCESSIVE_HEAT = 'excessiveHeat';
    /**
     * Constant for value 'frost'
     * @return string 'frost'
     */
    const VALUE_FROST = 'frost';
    /**
     * Constant for value 'holidayTraffic'
     * @return string 'holidayTraffic'
     */
    const VALUE_HOLIDAY_TRAFFIC = 'holidayTraffic';
    /**
     * Constant for value 'infrastructureFailure'
     * @return string 'infrastructureFailure'
     */
    const VALUE_INFRASTRUCTURE_FAILURE = 'infrastructureFailure';
    /**
     * Constant for value 'largeNumbersOfVisitors'
     * @return string 'largeNumbersOfVisitors'
     */
    const VALUE_LARGE_NUMBERS_OF_VISITORS = 'largeNumbersOfVisitors';
    /**
     * Constant for value 'obstruction'
     * @return string 'obstruction'
     */
    const VALUE_OBSTRUCTION = 'obstruction';
    /**
     * Constant for value 'pollutionAlert'
     * @return string 'pollutionAlert'
     */
    const VALUE_POLLUTION_ALERT = 'pollutionAlert';
    /**
     * Constant for value 'poorWeather'
     * @return string 'poorWeather'
     */
    const VALUE_POOR_WEATHER = 'poorWeather';
    /**
     * Constant for value 'problemsAtBorderPost'
     * @return string 'problemsAtBorderPost'
     */
    const VALUE_PROBLEMS_AT_BORDER_POST = 'problemsAtBorderPost';
    /**
     * Constant for value 'problemsAtCustomPost'
     * @return string 'problemsAtCustomPost'
     */
    const VALUE_PROBLEMS_AT_CUSTOM_POST = 'problemsAtCustomPost';
    /**
     * Constant for value 'problemsOnLocalRoads'
     * @return string 'problemsOnLocalRoads'
     */
    const VALUE_PROBLEMS_ON_LOCAL_ROADS = 'problemsOnLocalRoads';
    /**
     * Constant for value 'radioactiveLeakAlert'
     * @return string 'radioactiveLeakAlert'
     */
    const VALUE_RADIOACTIVE_LEAK_ALERT = 'radioactiveLeakAlert';
    /**
     * Constant for value 'roadsideEvent'
     * @return string 'roadsideEvent'
     */
    const VALUE_ROADSIDE_EVENT = 'roadsideEvent';
    /**
     * Constant for value 'rubberNecking'
     * @return string 'rubberNecking'
     */
    const VALUE_RUBBER_NECKING = 'rubberNecking';
    /**
     * Constant for value 'securityIncident'
     * @return string 'securityIncident'
     */
    const VALUE_SECURITY_INCIDENT = 'securityIncident';
    /**
     * Constant for value 'shearWeightOfTraffic'
     * @return string 'shearWeightOfTraffic'
     */
    const VALUE_SHEAR_WEIGHT_OF_TRAFFIC = 'shearWeightOfTraffic';
    /**
     * Constant for value 'technicalProblems'
     * @return string 'technicalProblems'
     */
    const VALUE_TECHNICAL_PROBLEMS = 'technicalProblems';
    /**
     * Constant for value 'terrorism'
     * @return string 'terrorism'
     */
    const VALUE_TERRORISM = 'terrorism';
    /**
     * Constant for value 'toxicCloudAlert'
     * @return string 'toxicCloudAlert'
     */
    const VALUE_TOXIC_CLOUD_ALERT = 'toxicCloudAlert';
    /**
     * Constant for value 'vandalism'
     * @return string 'vandalism'
     */
    const VALUE_VANDALISM = 'vandalism';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCIDENT
     * @uses self::VALUE_CONGESTION
     * @uses self::VALUE_EARLIER_ACCIDENT
     * @uses self::VALUE_EARLIER_EVENT
     * @uses self::VALUE_EARLIER_INCIDENT
     * @uses self::VALUE_EQUIPMENT_FAILURE
     * @uses self::VALUE_EXCESSIVE_HEAT
     * @uses self::VALUE_FROST
     * @uses self::VALUE_HOLIDAY_TRAFFIC
     * @uses self::VALUE_INFRASTRUCTURE_FAILURE
     * @uses self::VALUE_LARGE_NUMBERS_OF_VISITORS
     * @uses self::VALUE_OBSTRUCTION
     * @uses self::VALUE_POLLUTION_ALERT
     * @uses self::VALUE_POOR_WEATHER
     * @uses self::VALUE_PROBLEMS_AT_BORDER_POST
     * @uses self::VALUE_PROBLEMS_AT_CUSTOM_POST
     * @uses self::VALUE_PROBLEMS_ON_LOCAL_ROADS
     * @uses self::VALUE_RADIOACTIVE_LEAK_ALERT
     * @uses self::VALUE_ROADSIDE_EVENT
     * @uses self::VALUE_RUBBER_NECKING
     * @uses self::VALUE_SECURITY_INCIDENT
     * @uses self::VALUE_SHEAR_WEIGHT_OF_TRAFFIC
     * @uses self::VALUE_TECHNICAL_PROBLEMS
     * @uses self::VALUE_TERRORISM
     * @uses self::VALUE_TOXIC_CLOUD_ALERT
     * @uses self::VALUE_VANDALISM
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCIDENT,
            self::VALUE_CONGESTION,
            self::VALUE_EARLIER_ACCIDENT,
            self::VALUE_EARLIER_EVENT,
            self::VALUE_EARLIER_INCIDENT,
            self::VALUE_EQUIPMENT_FAILURE,
            self::VALUE_EXCESSIVE_HEAT,
            self::VALUE_FROST,
            self::VALUE_HOLIDAY_TRAFFIC,
            self::VALUE_INFRASTRUCTURE_FAILURE,
            self::VALUE_LARGE_NUMBERS_OF_VISITORS,
            self::VALUE_OBSTRUCTION,
            self::VALUE_POLLUTION_ALERT,
            self::VALUE_POOR_WEATHER,
            self::VALUE_PROBLEMS_AT_BORDER_POST,
            self::VALUE_PROBLEMS_AT_CUSTOM_POST,
            self::VALUE_PROBLEMS_ON_LOCAL_ROADS,
            self::VALUE_RADIOACTIVE_LEAK_ALERT,
            self::VALUE_ROADSIDE_EVENT,
            self::VALUE_RUBBER_NECKING,
            self::VALUE_SECURITY_INCIDENT,
            self::VALUE_SHEAR_WEIGHT_OF_TRAFFIC,
            self::VALUE_TECHNICAL_PROBLEMS,
            self::VALUE_TERRORISM,
            self::VALUE_TOXIC_CLOUD_ALERT,
            self::VALUE_VANDALISM,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
