<?php

namespace EnumType;

/**
 * This class stands for CarParkStatusEnum EnumType
 * @subpackage Enumerations
 */
class CarParkStatusEnum
{
    /**
     * Constant for value 'carParkClosed'
     * @return string 'carParkClosed'
     */
    const VALUE_CAR_PARK_CLOSED = 'carParkClosed';
    /**
     * Constant for value 'allCarParksFull'
     * @return string 'allCarParksFull'
     */
    const VALUE_ALL_CAR_PARKS_FULL = 'allCarParksFull';
    /**
     * Constant for value 'carParkFacilityFaulty'
     * @return string 'carParkFacilityFaulty'
     */
    const VALUE_CAR_PARK_FACILITY_FAULTY = 'carParkFacilityFaulty';
    /**
     * Constant for value 'carParkFull'
     * @return string 'carParkFull'
     */
    const VALUE_CAR_PARK_FULL = 'carParkFull';
    /**
     * Constant for value 'carParkStatusUnknown'
     * @return string 'carParkStatusUnknown'
     */
    const VALUE_CAR_PARK_STATUS_UNKNOWN = 'carParkStatusUnknown';
    /**
     * Constant for value 'enoughSpacesAvailable'
     * @return string 'enoughSpacesAvailable'
     */
    const VALUE_ENOUGH_SPACES_AVAILABLE = 'enoughSpacesAvailable';
    /**
     * Constant for value 'multiStoryCarParksFull'
     * @return string 'multiStoryCarParksFull'
     */
    const VALUE_MULTI_STORY_CAR_PARKS_FULL = 'multiStoryCarParksFull';
    /**
     * Constant for value 'noMoreParkingSpacesAvailable'
     * @return string 'noMoreParkingSpacesAvailable'
     */
    const VALUE_NO_MORE_PARKING_SPACES_AVAILABLE = 'noMoreParkingSpacesAvailable';
    /**
     * Constant for value 'noParkAndRideInformation'
     * @return string 'noParkAndRideInformation'
     */
    const VALUE_NO_PARK_AND_RIDE_INFORMATION = 'noParkAndRideInformation';
    /**
     * Constant for value 'noParkingAllowed'
     * @return string 'noParkingAllowed'
     */
    const VALUE_NO_PARKING_ALLOWED = 'noParkingAllowed';
    /**
     * Constant for value 'noParkingInformationAvailable'
     * @return string 'noParkingInformationAvailable'
     */
    const VALUE_NO_PARKING_INFORMATION_AVAILABLE = 'noParkingInformationAvailable';
    /**
     * Constant for value 'normalParkingRestrictionsLifted'
     * @return string 'normalParkingRestrictionsLifted'
     */
    const VALUE_NORMAL_PARKING_RESTRICTIONS_LIFTED = 'normalParkingRestrictionsLifted';
    /**
     * Constant for value 'onlyAFewSpacesAvailable'
     * @return string 'onlyAFewSpacesAvailable'
     */
    const VALUE_ONLY_AFEW_SPACES_AVAILABLE = 'onlyAFewSpacesAvailable';
    /**
     * Constant for value 'parkAndRideServiceNotOperating'
     * @return string 'parkAndRideServiceNotOperating'
     */
    const VALUE_PARK_AND_RIDE_SERVICE_NOT_OPERATING = 'parkAndRideServiceNotOperating';
    /**
     * Constant for value 'parkAndRideServiceOperating'
     * @return string 'parkAndRideServiceOperating'
     */
    const VALUE_PARK_AND_RIDE_SERVICE_OPERATING = 'parkAndRideServiceOperating';
    /**
     * Constant for value 'specialParkingRestrictionsInForce'
     * @return string 'specialParkingRestrictionsInForce'
     */
    const VALUE_SPECIAL_PARKING_RESTRICTIONS_IN_FORCE = 'specialParkingRestrictionsInForce';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CAR_PARK_CLOSED
     * @uses self::VALUE_ALL_CAR_PARKS_FULL
     * @uses self::VALUE_CAR_PARK_FACILITY_FAULTY
     * @uses self::VALUE_CAR_PARK_FULL
     * @uses self::VALUE_CAR_PARK_STATUS_UNKNOWN
     * @uses self::VALUE_ENOUGH_SPACES_AVAILABLE
     * @uses self::VALUE_MULTI_STORY_CAR_PARKS_FULL
     * @uses self::VALUE_NO_MORE_PARKING_SPACES_AVAILABLE
     * @uses self::VALUE_NO_PARK_AND_RIDE_INFORMATION
     * @uses self::VALUE_NO_PARKING_ALLOWED
     * @uses self::VALUE_NO_PARKING_INFORMATION_AVAILABLE
     * @uses self::VALUE_NORMAL_PARKING_RESTRICTIONS_LIFTED
     * @uses self::VALUE_ONLY_AFEW_SPACES_AVAILABLE
     * @uses self::VALUE_PARK_AND_RIDE_SERVICE_NOT_OPERATING
     * @uses self::VALUE_PARK_AND_RIDE_SERVICE_OPERATING
     * @uses self::VALUE_SPECIAL_PARKING_RESTRICTIONS_IN_FORCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CAR_PARK_CLOSED,
            self::VALUE_ALL_CAR_PARKS_FULL,
            self::VALUE_CAR_PARK_FACILITY_FAULTY,
            self::VALUE_CAR_PARK_FULL,
            self::VALUE_CAR_PARK_STATUS_UNKNOWN,
            self::VALUE_ENOUGH_SPACES_AVAILABLE,
            self::VALUE_MULTI_STORY_CAR_PARKS_FULL,
            self::VALUE_NO_MORE_PARKING_SPACES_AVAILABLE,
            self::VALUE_NO_PARK_AND_RIDE_INFORMATION,
            self::VALUE_NO_PARKING_ALLOWED,
            self::VALUE_NO_PARKING_INFORMATION_AVAILABLE,
            self::VALUE_NORMAL_PARKING_RESTRICTIONS_LIFTED,
            self::VALUE_ONLY_AFEW_SPACES_AVAILABLE,
            self::VALUE_PARK_AND_RIDE_SERVICE_NOT_OPERATING,
            self::VALUE_PARK_AND_RIDE_SERVICE_OPERATING,
            self::VALUE_SPECIAL_PARKING_RESTRICTIONS_IN_FORCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
