<?php

namespace EnumType;

/**
 * This class stands for CallStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Classification of the timeliness of the CALL, according to a fixed list of values. This may reflect a presentation policy, for example CALLs less than one minute behind target time are still classified as on-time. Applications may
 * use this to guide their own presentation of times.
 * @subpackage Enumerations
 */
class CallStatusEnumeration
{
    /**
     * Constant for value 'onTime'
     * @return string 'onTime'
     */
    const VALUE_ON_TIME = 'onTime';
    /**
     * Constant for value 'early'
     * @return string 'early'
     */
    const VALUE_EARLY = 'early';
    /**
     * Constant for value 'delayed'
     * @return string 'delayed'
     */
    const VALUE_DELAYED = 'delayed';
    /**
     * Constant for value 'cancelled'
     * @return string 'cancelled'
     */
    const VALUE_CANCELLED = 'cancelled';
    /**
     * Constant for value 'arrived'
     * @return string 'arrived'
     */
    const VALUE_ARRIVED = 'arrived';
    /**
     * Constant for value 'departed'
     * @return string 'departed'
     */
    const VALUE_DEPARTED = 'departed';
    /**
     * Constant for value 'missed'
     * @return string 'missed'
     */
    const VALUE_MISSED = 'missed';
    /**
     * Constant for value 'noReport'
     * @return string 'noReport'
     */
    const VALUE_NO_REPORT = 'noReport';
    /**
     * Constant for value 'notExpected'
     * @return string 'notExpected'
     */
    const VALUE_NOT_EXPECTED = 'notExpected';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ON_TIME
     * @uses self::VALUE_EARLY
     * @uses self::VALUE_DELAYED
     * @uses self::VALUE_CANCELLED
     * @uses self::VALUE_ARRIVED
     * @uses self::VALUE_DEPARTED
     * @uses self::VALUE_MISSED
     * @uses self::VALUE_NO_REPORT
     * @uses self::VALUE_NOT_EXPECTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ON_TIME,
            self::VALUE_EARLY,
            self::VALUE_DELAYED,
            self::VALUE_CANCELLED,
            self::VALUE_ARRIVED,
            self::VALUE_DEPARTED,
            self::VALUE_MISSED,
            self::VALUE_NO_REPORT,
            self::VALUE_NOT_EXPECTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
