<?php

namespace EnumType;

/**
 * This class stands for BookingStatusEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for TBookingStatus TPEG pti_table 24.
 * @subpackage Enumerations
 */
class BookingStatusEnumeration
{
    /**
     * Constant for value 'pti24_0'
     * @return string 'pti24_0'
     */
    const VALUE_PTI_24_0 = 'pti24_0';
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti17_1'
     * @return string 'pti17_1'
     */
    const VALUE_PTI_17_1 = 'pti17_1';
    /**
     * Constant for value 'available'
     * @return string 'available'
     */
    const VALUE_AVAILABLE = 'available';
    /**
     * Constant for value 'pti24_2'
     * @return string 'pti24_2'
     */
    const VALUE_PTI_24_2 = 'pti24_2';
    /**
     * Constant for value 'limited'
     * @return string 'limited'
     */
    const VALUE_LIMITED = 'limited';
    /**
     * Constant for value 'pti24_3'
     * @return string 'pti24_3'
     */
    const VALUE_PTI_24_3 = 'pti24_3';
    /**
     * Constant for value 'veryLimited'
     * @return string 'veryLimited'
     */
    const VALUE_VERY_LIMITED = 'veryLimited';
    /**
     * Constant for value 'pti24_4'
     * @return string 'pti24_4'
     */
    const VALUE_PTI_24_4 = 'pti24_4';
    /**
     * Constant for value 'full'
     * @return string 'full'
     */
    const VALUE_FULL = 'full';
    /**
     * Constant for value 'pti24_5'
     * @return string 'pti24_5'
     */
    const VALUE_PTI_24_5 = 'pti24_5';
    /**
     * Constant for value 'waitingList'
     * @return string 'waitingList'
     */
    const VALUE_WAITING_LIST = 'waitingList';
    /**
     * Constant for value 'pti24_6'
     * @return string 'pti24_6'
     */
    const VALUE_PTI_24_6 = 'pti24_6';
    /**
     * Constant for value 'noBookingRequired'
     * @return string 'noBookingRequired'
     */
    const VALUE_NO_BOOKING_REQUIRED = 'noBookingRequired';
    /**
     * Constant for value 'pti24_7'
     * @return string 'pti24_7'
     */
    const VALUE_PTI_24_7 = 'pti24_7';
    /**
     * Constant for value 'bookingRequired'
     * @return string 'bookingRequired'
     */
    const VALUE_BOOKING_REQUIRED = 'bookingRequired';
    /**
     * Constant for value 'pti24_8'
     * @return string 'pti24_8'
     */
    const VALUE_PTI_24_8 = 'pti24_8';
    /**
     * Constant for value 'bookingOptional'
     * @return string 'bookingOptional'
     */
    const VALUE_BOOKING_OPTIONAL = 'bookingOptional';
    /**
     * Constant for value 'pti24_255'
     * @return string 'pti24_255'
     */
    const VALUE_PTI_24_255 = 'pti24_255';
    /**
     * Constant for value 'undefinedBookingInformation'
     * @return string 'undefinedBookingInformation'
     */
    const VALUE_UNDEFINED_BOOKING_INFORMATION = 'undefinedBookingInformation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PTI_24_0
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_17_1
     * @uses self::VALUE_AVAILABLE
     * @uses self::VALUE_PTI_24_2
     * @uses self::VALUE_LIMITED
     * @uses self::VALUE_PTI_24_3
     * @uses self::VALUE_VERY_LIMITED
     * @uses self::VALUE_PTI_24_4
     * @uses self::VALUE_FULL
     * @uses self::VALUE_PTI_24_5
     * @uses self::VALUE_WAITING_LIST
     * @uses self::VALUE_PTI_24_6
     * @uses self::VALUE_NO_BOOKING_REQUIRED
     * @uses self::VALUE_PTI_24_7
     * @uses self::VALUE_BOOKING_REQUIRED
     * @uses self::VALUE_PTI_24_8
     * @uses self::VALUE_BOOKING_OPTIONAL
     * @uses self::VALUE_PTI_24_255
     * @uses self::VALUE_UNDEFINED_BOOKING_INFORMATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PTI_24_0,
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_17_1,
            self::VALUE_AVAILABLE,
            self::VALUE_PTI_24_2,
            self::VALUE_LIMITED,
            self::VALUE_PTI_24_3,
            self::VALUE_VERY_LIMITED,
            self::VALUE_PTI_24_4,
            self::VALUE_FULL,
            self::VALUE_PTI_24_5,
            self::VALUE_WAITING_LIST,
            self::VALUE_PTI_24_6,
            self::VALUE_NO_BOOKING_REQUIRED,
            self::VALUE_PTI_24_7,
            self::VALUE_BOOKING_REQUIRED,
            self::VALUE_PTI_24_8,
            self::VALUE_BOOKING_OPTIONAL,
            self::VALUE_PTI_24_255,
            self::VALUE_UNDEFINED_BOOKING_INFORMATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
