<?php

namespace EnumType;

/**
 * This class stands for AudienceEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Audience.
 * @subpackage Enumerations
 */
class AudienceEnumeration
{
    /**
     * Constant for value 'public'
     * @return string 'public'
     */
    const VALUE_PUBLIC = 'public';
    /**
     * Constant for value 'emergencyServices'
     * @return string 'emergencyServices'
     */
    const VALUE_EMERGENCY_SERVICES = 'emergencyServices';
    /**
     * Constant for value 'staff'
     * @return string 'staff'
     */
    const VALUE_STAFF = 'staff';
    /**
     * Constant for value 'stationStaff'
     * @return string 'stationStaff'
     */
    const VALUE_STATION_STAFF = 'stationStaff';
    /**
     * Constant for value 'management'
     * @return string 'management'
     */
    const VALUE_MANAGEMENT = 'management';
    /**
     * Constant for value 'infoServices'
     * @return string 'infoServices'
     */
    const VALUE_INFO_SERVICES = 'infoServices';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_PUBLIC
     * @uses self::VALUE_EMERGENCY_SERVICES
     * @uses self::VALUE_STAFF
     * @uses self::VALUE_STATION_STAFF
     * @uses self::VALUE_MANAGEMENT
     * @uses self::VALUE_INFO_SERVICES
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_PUBLIC,
            self::VALUE_EMERGENCY_SERVICES,
            self::VALUE_STAFF,
            self::VALUE_STATION_STAFF,
            self::VALUE_MANAGEMENT,
            self::VALUE_INFO_SERVICES,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
