<?php

namespace EnumType;

/**
 * This class stands for AssistanceFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Assistance Facility.
 * @subpackage Enumerations
 */
class AssistanceFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'police'
     * @return string 'police'
     */
    const VALUE_POLICE = 'police';
    /**
     * Constant for value 'firstAid'
     * @return string 'firstAid'
     */
    const VALUE_FIRST_AID = 'firstAid';
    /**
     * Constant for value 'sosPoint'
     * @return string 'sosPoint'
     */
    const VALUE_SOS_POINT = 'sosPoint';
    /**
     * Constant for value 'specificAssistance'
     * @return string 'specificAssistance'
     */
    const VALUE_SPECIFIC_ASSISTANCE = 'specificAssistance';
    /**
     * Constant for value 'unaccompaniedMinorAssistance'
     * @return string 'unaccompaniedMinorAssistance'
     */
    const VALUE_UNACCOMPANIED_MINOR_ASSISTANCE = 'unaccompaniedMinorAssistance';
    /**
     * Constant for value 'boardingAssistance'
     * @return string 'boardingAssistance'
     */
    const VALUE_BOARDING_ASSISTANCE = 'boardingAssistance';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_POLICE
     * @uses self::VALUE_FIRST_AID
     * @uses self::VALUE_SOS_POINT
     * @uses self::VALUE_SPECIFIC_ASSISTANCE
     * @uses self::VALUE_UNACCOMPANIED_MINOR_ASSISTANCE
     * @uses self::VALUE_BOARDING_ASSISTANCE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_POLICE,
            self::VALUE_FIRST_AID,
            self::VALUE_SOS_POINT,
            self::VALUE_SPECIFIC_ASSISTANCE,
            self::VALUE_UNACCOMPANIED_MINOR_ASSISTANCE,
            self::VALUE_BOARDING_ASSISTANCE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
