<?php

namespace EnumType;

/**
 * This class stands for AreaOfInterestEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Area Of Interest.
 * @subpackage Enumerations
 */
class AreaOfInterestEnumeration
{
    /**
     * Constant for value 'continentWide'
     * @return string 'continentWide'
     */
    const VALUE_CONTINENT_WIDE = 'continentWide';
    /**
     * Constant for value 'national'
     * @return string 'national'
     */
    const VALUE_NATIONAL = 'national';
    /**
     * Constant for value 'neighboroughingCountries'
     * @return string 'neighboroughingCountries'
     */
    const VALUE_NEIGHBOROUGHING_COUNTRIES = 'neighboroughingCountries';
    /**
     * Constant for value 'regional'
     * @return string 'regional'
     */
    const VALUE_REGIONAL = 'regional';
    /**
     * Constant for value 'notSpecified'
     * @return string 'notSpecified'
     */
    const VALUE_NOT_SPECIFIED = 'notSpecified';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONTINENT_WIDE
     * @uses self::VALUE_NATIONAL
     * @uses self::VALUE_NEIGHBOROUGHING_COUNTRIES
     * @uses self::VALUE_REGIONAL
     * @uses self::VALUE_NOT_SPECIFIED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONTINENT_WIDE,
            self::VALUE_NATIONAL,
            self::VALUE_NEIGHBOROUGHING_COUNTRIES,
            self::VALUE_REGIONAL,
            self::VALUE_NOT_SPECIFIED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
