<?php

namespace EnumType;

/**
 * This class stands for AccommodationFacilityEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Values for Accomodation Facility: TPEG pti_table 23.
 * @subpackage Enumerations
 */
class AccommodationFacilityEnumeration
{
    /**
     * Constant for value 'unknown'
     * @return string 'unknown'
     */
    const VALUE_UNKNOWN = 'unknown';
    /**
     * Constant for value 'pti23_3'
     * @return string 'pti23_3'
     */
    const VALUE_PTI_23_3 = 'pti23_3';
    /**
     * Constant for value 'sleeper'
     * @return string 'sleeper'
     */
    const VALUE_SLEEPER = 'sleeper';
    /**
     * Constant for value 'pti23_4'
     * @return string 'pti23_4'
     */
    const VALUE_PTI_23_4 = 'pti23_4';
    /**
     * Constant for value 'couchette'
     * @return string 'couchette'
     */
    const VALUE_COUCHETTE = 'couchette';
    /**
     * Constant for value 'pti23_5'
     * @return string 'pti23_5'
     */
    const VALUE_PTI_23_5 = 'pti23_5';
    /**
     * Constant for value 'specialSeating'
     * @return string 'specialSeating'
     */
    const VALUE_SPECIAL_SEATING = 'specialSeating';
    /**
     * Constant for value 'pti23_11'
     * @return string 'pti23_11'
     */
    const VALUE_PTI_23_11 = 'pti23_11';
    /**
     * Constant for value 'freeSeating'
     * @return string 'freeSeating'
     */
    const VALUE_FREE_SEATING = 'freeSeating';
    /**
     * Constant for value 'pti23_12'
     * @return string 'pti23_12'
     */
    const VALUE_PTI_23_12 = 'pti23_12';
    /**
     * Constant for value 'recliningSeats'
     * @return string 'recliningSeats'
     */
    const VALUE_RECLINING_SEATS = 'recliningSeats';
    /**
     * Constant for value 'pti23_13'
     * @return string 'pti23_13'
     */
    const VALUE_PTI_23_13 = 'pti23_13';
    /**
     * Constant for value 'babyCompartment'
     * @return string 'babyCompartment'
     */
    const VALUE_BABY_COMPARTMENT = 'babyCompartment';
    /**
     * Constant for value 'familyCarriage'
     * @return string 'familyCarriage'
     */
    const VALUE_FAMILY_CARRIAGE = 'familyCarriage';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_PTI_23_3
     * @uses self::VALUE_SLEEPER
     * @uses self::VALUE_PTI_23_4
     * @uses self::VALUE_COUCHETTE
     * @uses self::VALUE_PTI_23_5
     * @uses self::VALUE_SPECIAL_SEATING
     * @uses self::VALUE_PTI_23_11
     * @uses self::VALUE_FREE_SEATING
     * @uses self::VALUE_PTI_23_12
     * @uses self::VALUE_RECLINING_SEATS
     * @uses self::VALUE_PTI_23_13
     * @uses self::VALUE_BABY_COMPARTMENT
     * @uses self::VALUE_FAMILY_CARRIAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_PTI_23_3,
            self::VALUE_SLEEPER,
            self::VALUE_PTI_23_4,
            self::VALUE_COUCHETTE,
            self::VALUE_PTI_23_5,
            self::VALUE_SPECIAL_SEATING,
            self::VALUE_PTI_23_11,
            self::VALUE_FREE_SEATING,
            self::VALUE_PTI_23_12,
            self::VALUE_RECLINING_SEATS,
            self::VALUE_PTI_23_13,
            self::VALUE_BABY_COMPARTMENT,
            self::VALUE_FAMILY_CARRIAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
