<?php

namespace EnumType;

/**
 * This class stands for AccidentTypeEnum EnumType
 * @subpackage Enumerations
 */
class AccidentTypeEnum
{
    /**
     * Constant for value 'accident'
     * @return string 'accident'
     */
    const VALUE_ACCIDENT = 'accident';
    /**
     * Constant for value 'accidentInvolvingBicycles'
     * @return string 'accidentInvolvingBicycles'
     */
    const VALUE_ACCIDENT_INVOLVING_BICYCLES = 'accidentInvolvingBicycles';
    /**
     * Constant for value 'accidentInvolvingBuses'
     * @return string 'accidentInvolvingBuses'
     */
    const VALUE_ACCIDENT_INVOLVING_BUSES = 'accidentInvolvingBuses';
    /**
     * Constant for value 'accidentInvolvingHazardousMaterials'
     * @return string 'accidentInvolvingHazardousMaterials'
     */
    const VALUE_ACCIDENT_INVOLVING_HAZARDOUS_MATERIALS = 'accidentInvolvingHazardousMaterials';
    /**
     * Constant for value 'accidentInvolvingHeavyLorries'
     * @return string 'accidentInvolvingHeavyLorries'
     */
    const VALUE_ACCIDENT_INVOLVING_HEAVY_LORRIES = 'accidentInvolvingHeavyLorries';
    /**
     * Constant for value 'accidentInvolvingMassTransitVehicle'
     * @return string 'accidentInvolvingMassTransitVehicle'
     */
    const VALUE_ACCIDENT_INVOLVING_MASS_TRANSIT_VEHICLE = 'accidentInvolvingMassTransitVehicle';
    /**
     * Constant for value 'accidentInvolvingMopeds'
     * @return string 'accidentInvolvingMopeds'
     */
    const VALUE_ACCIDENT_INVOLVING_MOPEDS = 'accidentInvolvingMopeds';
    /**
     * Constant for value 'accidentInvolvingMotorcycles'
     * @return string 'accidentInvolvingMotorcycles'
     */
    const VALUE_ACCIDENT_INVOLVING_MOTORCYCLES = 'accidentInvolvingMotorcycles';
    /**
     * Constant for value 'accidentInvolvingRadioactiveMaterial'
     * @return string 'accidentInvolvingRadioactiveMaterial'
     */
    const VALUE_ACCIDENT_INVOLVING_RADIOACTIVE_MATERIAL = 'accidentInvolvingRadioactiveMaterial';
    /**
     * Constant for value 'accidentInvolvingTrain'
     * @return string 'accidentInvolvingTrain'
     */
    const VALUE_ACCIDENT_INVOLVING_TRAIN = 'accidentInvolvingTrain';
    /**
     * Constant for value 'chemicalSpillageAccident'
     * @return string 'chemicalSpillageAccident'
     */
    const VALUE_CHEMICAL_SPILLAGE_ACCIDENT = 'chemicalSpillageAccident';
    /**
     * Constant for value 'collision'
     * @return string 'collision'
     */
    const VALUE_COLLISION = 'collision';
    /**
     * Constant for value 'collisionWithAnimal'
     * @return string 'collisionWithAnimal'
     */
    const VALUE_COLLISION_WITH_ANIMAL = 'collisionWithAnimal';
    /**
     * Constant for value 'collisionWithObstruction'
     * @return string 'collisionWithObstruction'
     */
    const VALUE_COLLISION_WITH_OBSTRUCTION = 'collisionWithObstruction';
    /**
     * Constant for value 'collisionWithPerson'
     * @return string 'collisionWithPerson'
     */
    const VALUE_COLLISION_WITH_PERSON = 'collisionWithPerson';
    /**
     * Constant for value 'earlierAccident'
     * @return string 'earlierAccident'
     */
    const VALUE_EARLIER_ACCIDENT = 'earlierAccident';
    /**
     * Constant for value 'fuelSpillageAccident'
     * @return string 'fuelSpillageAccident'
     */
    const VALUE_FUEL_SPILLAGE_ACCIDENT = 'fuelSpillageAccident';
    /**
     * Constant for value 'headOnCollision'
     * @return string 'headOnCollision'
     */
    const VALUE_HEAD_ON_COLLISION = 'headOnCollision';
    /**
     * Constant for value 'headOnOrSideCollision'
     * @return string 'headOnOrSideCollision'
     */
    const VALUE_HEAD_ON_OR_SIDE_COLLISION = 'headOnOrSideCollision';
    /**
     * Constant for value 'jackknifedArticulatedLorry'
     * @return string 'jackknifedArticulatedLorry'
     */
    const VALUE_JACKKNIFED_ARTICULATED_LORRY = 'jackknifedArticulatedLorry';
    /**
     * Constant for value 'jackknifedCaravan'
     * @return string 'jackknifedCaravan'
     */
    const VALUE_JACKKNIFED_CARAVAN = 'jackknifedCaravan';
    /**
     * Constant for value 'jackknifedTrailer'
     * @return string 'jackknifedTrailer'
     */
    const VALUE_JACKKNIFED_TRAILER = 'jackknifedTrailer';
    /**
     * Constant for value 'multipleVehicleCollision'
     * @return string 'multipleVehicleCollision'
     */
    const VALUE_MULTIPLE_VEHICLE_COLLISION = 'multipleVehicleCollision';
    /**
     * Constant for value 'multivehicleAccident'
     * @return string 'multivehicleAccident'
     */
    const VALUE_MULTIVEHICLE_ACCIDENT = 'multivehicleAccident';
    /**
     * Constant for value 'oilSpillageAccident'
     * @return string 'oilSpillageAccident'
     */
    const VALUE_OIL_SPILLAGE_ACCIDENT = 'oilSpillageAccident';
    /**
     * Constant for value 'overturnedHeavyLorry'
     * @return string 'overturnedHeavyLorry'
     */
    const VALUE_OVERTURNED_HEAVY_LORRY = 'overturnedHeavyLorry';
    /**
     * Constant for value 'overturnedTrailer'
     * @return string 'overturnedTrailer'
     */
    const VALUE_OVERTURNED_TRAILER = 'overturnedTrailer';
    /**
     * Constant for value 'overturnedVehicle'
     * @return string 'overturnedVehicle'
     */
    const VALUE_OVERTURNED_VEHICLE = 'overturnedVehicle';
    /**
     * Constant for value 'rearCollision'
     * @return string 'rearCollision'
     */
    const VALUE_REAR_COLLISION = 'rearCollision';
    /**
     * Constant for value 'secondaryAccident'
     * @return string 'secondaryAccident'
     */
    const VALUE_SECONDARY_ACCIDENT = 'secondaryAccident';
    /**
     * Constant for value 'seriousAccident'
     * @return string 'seriousAccident'
     */
    const VALUE_SERIOUS_ACCIDENT = 'seriousAccident';
    /**
     * Constant for value 'sideCollision'
     * @return string 'sideCollision'
     */
    const VALUE_SIDE_COLLISION = 'sideCollision';
    /**
     * Constant for value 'vehicleOffRoad'
     * @return string 'vehicleOffRoad'
     */
    const VALUE_VEHICLE_OFF_ROAD = 'vehicleOffRoad';
    /**
     * Constant for value 'vehicleSpunAround'
     * @return string 'vehicleSpunAround'
     */
    const VALUE_VEHICLE_SPUN_AROUND = 'vehicleSpunAround';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCIDENT
     * @uses self::VALUE_ACCIDENT_INVOLVING_BICYCLES
     * @uses self::VALUE_ACCIDENT_INVOLVING_BUSES
     * @uses self::VALUE_ACCIDENT_INVOLVING_HAZARDOUS_MATERIALS
     * @uses self::VALUE_ACCIDENT_INVOLVING_HEAVY_LORRIES
     * @uses self::VALUE_ACCIDENT_INVOLVING_MASS_TRANSIT_VEHICLE
     * @uses self::VALUE_ACCIDENT_INVOLVING_MOPEDS
     * @uses self::VALUE_ACCIDENT_INVOLVING_MOTORCYCLES
     * @uses self::VALUE_ACCIDENT_INVOLVING_RADIOACTIVE_MATERIAL
     * @uses self::VALUE_ACCIDENT_INVOLVING_TRAIN
     * @uses self::VALUE_CHEMICAL_SPILLAGE_ACCIDENT
     * @uses self::VALUE_COLLISION
     * @uses self::VALUE_COLLISION_WITH_ANIMAL
     * @uses self::VALUE_COLLISION_WITH_OBSTRUCTION
     * @uses self::VALUE_COLLISION_WITH_PERSON
     * @uses self::VALUE_EARLIER_ACCIDENT
     * @uses self::VALUE_FUEL_SPILLAGE_ACCIDENT
     * @uses self::VALUE_HEAD_ON_COLLISION
     * @uses self::VALUE_HEAD_ON_OR_SIDE_COLLISION
     * @uses self::VALUE_JACKKNIFED_ARTICULATED_LORRY
     * @uses self::VALUE_JACKKNIFED_CARAVAN
     * @uses self::VALUE_JACKKNIFED_TRAILER
     * @uses self::VALUE_MULTIPLE_VEHICLE_COLLISION
     * @uses self::VALUE_MULTIVEHICLE_ACCIDENT
     * @uses self::VALUE_OIL_SPILLAGE_ACCIDENT
     * @uses self::VALUE_OVERTURNED_HEAVY_LORRY
     * @uses self::VALUE_OVERTURNED_TRAILER
     * @uses self::VALUE_OVERTURNED_VEHICLE
     * @uses self::VALUE_REAR_COLLISION
     * @uses self::VALUE_SECONDARY_ACCIDENT
     * @uses self::VALUE_SERIOUS_ACCIDENT
     * @uses self::VALUE_SIDE_COLLISION
     * @uses self::VALUE_VEHICLE_OFF_ROAD
     * @uses self::VALUE_VEHICLE_SPUN_AROUND
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCIDENT,
            self::VALUE_ACCIDENT_INVOLVING_BICYCLES,
            self::VALUE_ACCIDENT_INVOLVING_BUSES,
            self::VALUE_ACCIDENT_INVOLVING_HAZARDOUS_MATERIALS,
            self::VALUE_ACCIDENT_INVOLVING_HEAVY_LORRIES,
            self::VALUE_ACCIDENT_INVOLVING_MASS_TRANSIT_VEHICLE,
            self::VALUE_ACCIDENT_INVOLVING_MOPEDS,
            self::VALUE_ACCIDENT_INVOLVING_MOTORCYCLES,
            self::VALUE_ACCIDENT_INVOLVING_RADIOACTIVE_MATERIAL,
            self::VALUE_ACCIDENT_INVOLVING_TRAIN,
            self::VALUE_CHEMICAL_SPILLAGE_ACCIDENT,
            self::VALUE_COLLISION,
            self::VALUE_COLLISION_WITH_ANIMAL,
            self::VALUE_COLLISION_WITH_OBSTRUCTION,
            self::VALUE_COLLISION_WITH_PERSON,
            self::VALUE_EARLIER_ACCIDENT,
            self::VALUE_FUEL_SPILLAGE_ACCIDENT,
            self::VALUE_HEAD_ON_COLLISION,
            self::VALUE_HEAD_ON_OR_SIDE_COLLISION,
            self::VALUE_JACKKNIFED_ARTICULATED_LORRY,
            self::VALUE_JACKKNIFED_CARAVAN,
            self::VALUE_JACKKNIFED_TRAILER,
            self::VALUE_MULTIPLE_VEHICLE_COLLISION,
            self::VALUE_MULTIVEHICLE_ACCIDENT,
            self::VALUE_OIL_SPILLAGE_ACCIDENT,
            self::VALUE_OVERTURNED_HEAVY_LORRY,
            self::VALUE_OVERTURNED_TRAILER,
            self::VALUE_OVERTURNED_VEHICLE,
            self::VALUE_REAR_COLLISION,
            self::VALUE_SECONDARY_ACCIDENT,
            self::VALUE_SERIOUS_ACCIDENT,
            self::VALUE_SIDE_COLLISION,
            self::VALUE_VEHICLE_OFF_ROAD,
            self::VALUE_VEHICLE_SPUN_AROUND,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
