<?php

namespace EnumType;

/**
 * This class stands for AccessSpaceTypeEnumeration EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Enumeration of ACCESS SPACE Types.
 * @subpackage Enumerations
 */
class AccessSpaceTypeEnumeration
{
    /**
     * Constant for value 'concours'
     * @return string 'concours'
     */
    const VALUE_CONCOURS = 'concours';
    /**
     * Constant for value 'bookingHall'
     * @return string 'bookingHall'
     */
    const VALUE_BOOKING_HALL = 'bookingHall';
    /**
     * Constant for value 'forecourt'
     * @return string 'forecourt'
     */
    const VALUE_FORECOURT = 'forecourt';
    /**
     * Constant for value 'underpass'
     * @return string 'underpass'
     */
    const VALUE_UNDERPASS = 'underpass';
    /**
     * Constant for value 'overpass'
     * @return string 'overpass'
     */
    const VALUE_OVERPASS = 'overpass';
    /**
     * Constant for value 'passage'
     * @return string 'passage'
     */
    const VALUE_PASSAGE = 'passage';
    /**
     * Constant for value 'passageSection'
     * @return string 'passageSection'
     */
    const VALUE_PASSAGE_SECTION = 'passageSection';
    /**
     * Constant for value 'gallery'
     * @return string 'gallery'
     */
    const VALUE_GALLERY = 'gallery';
    /**
     * Constant for value 'garage'
     * @return string 'garage'
     */
    const VALUE_GARAGE = 'garage';
    /**
     * Constant for value 'shop'
     * @return string 'shop'
     */
    const VALUE_SHOP = 'shop';
    /**
     * Constant for value 'waitingRoom'
     * @return string 'waitingRoom'
     */
    const VALUE_WAITING_ROOM = 'waitingRoom';
    /**
     * Constant for value 'restaurant'
     * @return string 'restaurant'
     */
    const VALUE_RESTAURANT = 'restaurant';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CONCOURS
     * @uses self::VALUE_BOOKING_HALL
     * @uses self::VALUE_FORECOURT
     * @uses self::VALUE_UNDERPASS
     * @uses self::VALUE_OVERPASS
     * @uses self::VALUE_PASSAGE
     * @uses self::VALUE_PASSAGE_SECTION
     * @uses self::VALUE_GALLERY
     * @uses self::VALUE_GARAGE
     * @uses self::VALUE_SHOP
     * @uses self::VALUE_WAITING_ROOM
     * @uses self::VALUE_RESTAURANT
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CONCOURS,
            self::VALUE_BOOKING_HALL,
            self::VALUE_FORECOURT,
            self::VALUE_UNDERPASS,
            self::VALUE_OVERPASS,
            self::VALUE_PASSAGE,
            self::VALUE_PASSAGE_SECTION,
            self::VALUE_GALLERY,
            self::VALUE_GARAGE,
            self::VALUE_SHOP,
            self::VALUE_WAITING_ROOM,
            self::VALUE_RESTAURANT,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
