<?php

namespace EnumType;

/**
 * This class stands for AbnormalTrafficTypeEnum EnumType
 * @subpackage Enumerations
 */
class AbnormalTrafficTypeEnum
{
    /**
     * Constant for value 'stationaryTraffic'
     * @return string 'stationaryTraffic'
     */
    const VALUE_STATIONARY_TRAFFIC = 'stationaryTraffic';
    /**
     * Constant for value 'queuingTraffic'
     * @return string 'queuingTraffic'
     */
    const VALUE_QUEUING_TRAFFIC = 'queuingTraffic';
    /**
     * Constant for value 'slowTraffic'
     * @return string 'slowTraffic'
     */
    const VALUE_SLOW_TRAFFIC = 'slowTraffic';
    /**
     * Constant for value 'heavyTraffic'
     * @return string 'heavyTraffic'
     */
    const VALUE_HEAVY_TRAFFIC = 'heavyTraffic';
    /**
     * Constant for value 'unspecifiedAbnormalTraffic'
     * @return string 'unspecifiedAbnormalTraffic'
     */
    const VALUE_UNSPECIFIED_ABNORMAL_TRAFFIC = 'unspecifiedAbnormalTraffic';
    /**
     * Constant for value 'other'
     * @return string 'other'
     */
    const VALUE_OTHER = 'other';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_STATIONARY_TRAFFIC
     * @uses self::VALUE_QUEUING_TRAFFIC
     * @uses self::VALUE_SLOW_TRAFFIC
     * @uses self::VALUE_HEAVY_TRAFFIC
     * @uses self::VALUE_UNSPECIFIED_ABNORMAL_TRAFFIC
     * @uses self::VALUE_OTHER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_STATIONARY_TRAFFIC,
            self::VALUE_QUEUING_TRAFFIC,
            self::VALUE_SLOW_TRAFFIC,
            self::VALUE_HEAVY_TRAFFIC,
            self::VALUE_UNSPECIFIED_ABNORMAL_TRAFFIC,
            self::VALUE_OTHER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
