<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://raw.githubusercontent.com/VDVde/SIRI/master/siri_wsProducer.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://raw.githubusercontent.com/VDVde/SIRI/master/siri_wsProducer.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Subscribe ServiceType
 */
$subscribe = new \ServiceType\Subscribe($options);
/**
 * Sample call for Subscribe operation/method
 */
if ($subscribe->Subscribe(new \StructType\WsSubscriptionRequestInfoStructure(), new \StructType\SiriSubscriptionRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($subscribe->getResult());
} else {
    print_r($subscribe->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for DeleteSubscription operation/method
 */
if ($delete->DeleteSubscription(new \StructType\RequestStructure(), new \StructType\TerminateSubscriptionRequestBodyStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Data ServiceType
 */
$data = new \ServiceType\Data($options);
/**
 * Sample call for DataSupply operation/method
 */
if ($data->DataSupply(new \StructType\ConsumerRequestEndpointStructure(), new \StructType\DataSupplyRequestBodyStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($data->getResult());
} else {
    print_r($data->getLastError());
}
/**
 * Samples for Check ServiceType
 */
$check = new \ServiceType\Check($options);
/**
 * Sample call for CheckStatus operation/method
 */
if ($check->CheckStatus(new \StructType\CheckStatusRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($check->getResult());
} else {
    print_r($check->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetProductionTimetable operation/method
 */
if ($get->GetProductionTimetable(new \StructType\WsServiceRequestInfoStructure(), new \StructType\ProductionTimetableRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetEstimatedTimetable operation/method
 */
if ($get->GetEstimatedTimetable(new \StructType\WsServiceRequestInfoStructure(), new \StructType\EstimatedTimetableRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStopTimetable operation/method
 */
if ($get->GetStopTimetable(new \StructType\WsServiceRequestInfoStructure(), new \StructType\StopTimetableRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetStopMonitoring operation/method
 */
if ($get->GetStopMonitoring(new \StructType\WsServiceRequestInfoStructure(), new \StructType\StopMonitoringRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetMultipleStopMonitoring operation/method
 */
if ($get->GetMultipleStopMonitoring(new \StructType\WsServiceRequestInfoStructure(), new \StructType\StopMonitoringMultipleRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetVehicleMonitoring operation/method
 */
if ($get->GetVehicleMonitoring(new \StructType\WsServiceRequestInfoStructure(), new \StructType\VehicleMonitoringRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConnectionTimetable operation/method
 */
if ($get->GetConnectionTimetable(new \StructType\WsServiceRequestInfoStructure(), new \StructType\ConnectionTimetableRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetConnectionMonitoring operation/method
 */
if ($get->GetConnectionMonitoring(new \StructType\WsServiceRequestInfoStructure(), new \StructType\ConnectionMonitoringRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetGeneralMessage operation/method
 */
if ($get->GetGeneralMessage(new \StructType\WsServiceRequestInfoStructure(), new \StructType\GeneralMessageRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetFacilityMonitoring operation/method
 */
if ($get->GetFacilityMonitoring(new \StructType\WsServiceRequestInfoStructure(), new \StructType\FacilityMonitoringRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSituationExchange operation/method
 */
if ($get->GetSituationExchange(new \StructType\WsServiceRequestInfoStructure(), new \StructType\SituationExchangeRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCapabilities operation/method
 */
if ($get->GetCapabilities(new \StructType\CapabilitiesRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetSiriService operation/method
 */
if ($get->GetSiriService(new \StructType\ServiceRequestStructure()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Stop ServiceType
 */
$stop = new \ServiceType\Stop($options);
/**
 * Sample call for StopPointsDiscovery operation/method
 */
if ($stop->StopPointsDiscovery(new \StructType\StopPointsDiscoveryRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($stop->getResult());
} else {
    print_r($stop->getLastError());
}
/**
 * Samples for Lines ServiceType
 */
$lines = new \ServiceType\Lines($options);
/**
 * Sample call for LinesDiscovery operation/method
 */
if ($lines->LinesDiscovery(new \StructType\LinesDiscoveryRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($lines->getResult());
} else {
    print_r($lines->getLastError());
}
/**
 * Samples for Connection ServiceType
 */
$connection = new \ServiceType\Connection($options);
/**
 * Sample call for ConnectionLinksDiscovery operation/method
 */
if ($connection->ConnectionLinksDiscovery(new \StructType\ConnectionLinksDiscoveryRequestStructure(), new \StructType\ExtensionsStructure()) !== false) {
    print_r($connection->getResult());
} else {
    print_r($connection->getLastError());
}
