<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WinterDrivingManagement StructType
 * @subpackage Structs
 */
class WinterDrivingManagement extends NetworkManagement
{
    /**
     * The winterEquipmentManagementType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $winterEquipmentManagementType;
    /**
     * The winterDrivingManagementExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $winterDrivingManagementExtension;
    /**
     * Constructor method for WinterDrivingManagement
     * @uses WinterDrivingManagement::setWinterEquipmentManagementType()
     * @uses WinterDrivingManagement::setWinterDrivingManagementExtension()
     * @param string $winterEquipmentManagementType
     * @param \StructType\ExtensionType $winterDrivingManagementExtension
     */
    public function __construct($winterEquipmentManagementType = null, \StructType\ExtensionType $winterDrivingManagementExtension = null)
    {
        $this
            ->setWinterEquipmentManagementType($winterEquipmentManagementType)
            ->setWinterDrivingManagementExtension($winterDrivingManagementExtension);
    }
    /**
     * Get winterEquipmentManagementType value
     * @return string
     */
    public function getWinterEquipmentManagementType()
    {
        return $this->winterEquipmentManagementType;
    }
    /**
     * Set winterEquipmentManagementType value
     * @uses \EnumType\WinterEquipmentManagementTypeEnum::valueIsValid()
     * @uses \EnumType\WinterEquipmentManagementTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $winterEquipmentManagementType
     * @return \StructType\WinterDrivingManagement
     */
    public function setWinterEquipmentManagementType($winterEquipmentManagementType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\WinterEquipmentManagementTypeEnum::valueIsValid($winterEquipmentManagementType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $winterEquipmentManagementType, implode(', ', \EnumType\WinterEquipmentManagementTypeEnum::getValidValues())), __LINE__);
        }
        $this->winterEquipmentManagementType = $winterEquipmentManagementType;
        return $this;
    }
    /**
     * Get winterDrivingManagementExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getWinterDrivingManagementExtension()
    {
        return $this->winterDrivingManagementExtension;
    }
    /**
     * Set winterDrivingManagementExtension value
     * @param \StructType\ExtensionType $winterDrivingManagementExtension
     * @return \StructType\WinterDrivingManagement
     */
    public function setWinterDrivingManagementExtension(\StructType\ExtensionType $winterDrivingManagementExtension = null)
    {
        $this->winterDrivingManagementExtension = $winterDrivingManagementExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WinterDrivingManagement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
