<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WaitProlongedDepartureStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Distributor prolonged wait action.
 * @subpackage Structs
 */
class WaitProlongedDepartureStructure extends AbstractDistributorItemStructure
{
    /**
     * The ExpectedDepartureTime
     * Meta informations extracted from the WSDL
     * - documentation: Estimated departure time from the connection.
     * - minOccurs: 0
     * @var string
     */
    public $ExpectedDepartureTime;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for WaitProlongedDepartureStructure
     * @uses WaitProlongedDepartureStructure::setExpectedDepartureTime()
     * @uses WaitProlongedDepartureStructure::setExtensions()
     * @param string $expectedDepartureTime
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($expectedDepartureTime = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setExpectedDepartureTime($expectedDepartureTime)
            ->setExtensions($extensions);
    }
    /**
     * Get ExpectedDepartureTime value
     * @return string|null
     */
    public function getExpectedDepartureTime()
    {
        return $this->ExpectedDepartureTime;
    }
    /**
     * Set ExpectedDepartureTime value
     * @param string $expectedDepartureTime
     * @return \StructType\WaitProlongedDepartureStructure
     */
    public function setExpectedDepartureTime($expectedDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($expectedDepartureTime) && !is_string($expectedDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expectedDepartureTime)), __LINE__);
        }
        $this->ExpectedDepartureTime = $expectedDepartureTime;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\WaitProlongedDepartureStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WaitProlongedDepartureStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
