<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Visibility StructType
 * @subpackage Structs
 */
class Visibility extends AbstractStructBase
{
    /**
     * The minimumVisibilityDistance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $minimumVisibilityDistance;
    /**
     * The visibilityExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $visibilityExtension;
    /**
     * Constructor method for Visibility
     * @uses Visibility::setMinimumVisibilityDistance()
     * @uses Visibility::setVisibilityExtension()
     * @param int $minimumVisibilityDistance
     * @param \StructType\ExtensionType $visibilityExtension
     */
    public function __construct($minimumVisibilityDistance = null, \StructType\ExtensionType $visibilityExtension = null)
    {
        $this
            ->setMinimumVisibilityDistance($minimumVisibilityDistance)
            ->setVisibilityExtension($visibilityExtension);
    }
    /**
     * Get minimumVisibilityDistance value
     * @return int
     */
    public function getMinimumVisibilityDistance()
    {
        return $this->minimumVisibilityDistance;
    }
    /**
     * Set minimumVisibilityDistance value
     * @param int $minimumVisibilityDistance
     * @return \StructType\Visibility
     */
    public function setMinimumVisibilityDistance($minimumVisibilityDistance = null)
    {
        // validation for constraint: int
        if (!is_null($minimumVisibilityDistance) && !is_numeric($minimumVisibilityDistance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($minimumVisibilityDistance)), __LINE__);
        }
        $this->minimumVisibilityDistance = $minimumVisibilityDistance;
        return $this;
    }
    /**
     * Get visibilityExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVisibilityExtension()
    {
        return $this->visibilityExtension;
    }
    /**
     * Set visibilityExtension value
     * @param \StructType\ExtensionType $visibilityExtension
     * @return \StructType\Visibility
     */
    public function setVisibilityExtension(\StructType\ExtensionType $visibilityExtension = null)
    {
        $this->visibilityExtension = $visibilityExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Visibility
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
