<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleJourneys StructType
 * Meta informations extracted from the WSDL
 * - documentation: Specific journeys affected by SITUATION.
 * @subpackage Structs
 */
class VehicleJourneys extends AbstractStructBase
{
    /**
     * The AffectedVehicleJourney
     * Meta informations extracted from the WSDL
     * - documentation: Journeys affected by the SITUATION.
     * - maxOccurs: unbounded
     * @var \StructType\AffectedVehicleJourneyStructure[]
     */
    public $AffectedVehicleJourney;
    /**
     * Constructor method for VehicleJourneys
     * @uses VehicleJourneys::setAffectedVehicleJourney()
     * @param \StructType\AffectedVehicleJourneyStructure[] $affectedVehicleJourney
     */
    public function __construct(array $affectedVehicleJourney = array())
    {
        $this
            ->setAffectedVehicleJourney($affectedVehicleJourney);
    }
    /**
     * Get AffectedVehicleJourney value
     * @return \StructType\AffectedVehicleJourneyStructure[]|null
     */
    public function getAffectedVehicleJourney()
    {
        return $this->AffectedVehicleJourney;
    }
    /**
     * Set AffectedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedVehicleJourneyStructure[] $affectedVehicleJourney
     * @return \StructType\VehicleJourneys
     */
    public function setAffectedVehicleJourney(array $affectedVehicleJourney = array())
    {
        foreach ($affectedVehicleJourney as $vehicleJourneysAffectedVehicleJourneyItem) {
            // validation for constraint: itemType
            if (!$vehicleJourneysAffectedVehicleJourneyItem instanceof \StructType\AffectedVehicleJourneyStructure) {
                throw new \InvalidArgumentException(sprintf('The AffectedVehicleJourney property can only contain items of \StructType\AffectedVehicleJourneyStructure, "%s" given', is_object($vehicleJourneysAffectedVehicleJourneyItem) ? get_class($vehicleJourneysAffectedVehicleJourneyItem) : gettype($vehicleJourneysAffectedVehicleJourneyItem)), __LINE__);
            }
        }
        $this->AffectedVehicleJourney = $affectedVehicleJourney;
        return $this;
    }
    /**
     * Add item to AffectedVehicleJourney value
     * @throws \InvalidArgumentException
     * @param \StructType\AffectedVehicleJourneyStructure $item
     * @return \StructType\VehicleJourneys
     */
    public function addToAffectedVehicleJourney(\StructType\AffectedVehicleJourneyStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AffectedVehicleJourneyStructure) {
            throw new \InvalidArgumentException(sprintf('The AffectedVehicleJourney property can only contain items of \StructType\AffectedVehicleJourneyStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AffectedVehicleJourney[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleJourneys
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
