<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleFeaturesStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for description of feature of VEHICLE.
 * @subpackage Structs
 */
class VehicleFeaturesStructure extends AbstractStructBase
{
    /**
     * The VehicleFeatureCode
     * Meta informations extracted from the WSDL
     * - documentation: Identifier of feature of VEHICLE. SIRI provides a recommended set of values covering most usages, intended to be TPEG compatible. See the SIRI facilities packaged. | Type for identifier of a Vehicle Feature. SIRI provides a
     * recommended set of values covering most usages, intended to be TPEG comnpatible. See the SIRI facilities packaged.
     * @var string
     */
    public $VehicleFeatureCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: Name of feature of VEHICLE. (Unbounded since SIRI 2.0)
     * - maxOccurs: unbounded
     * @var \StructType\NaturalLanguageStringStructure[]
     */
    public $Name;
    /**
     * The Icon
     * Meta informations extracted from the WSDL
     * - documentation: Icon used to represent feature of VEHICLE.
     * @var string
     */
    public $Icon;
    /**
     * Constructor method for VehicleFeaturesStructure
     * @uses VehicleFeaturesStructure::setVehicleFeatureCode()
     * @uses VehicleFeaturesStructure::setName()
     * @uses VehicleFeaturesStructure::setIcon()
     * @param string $vehicleFeatureCode
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @param string $icon
     */
    public function __construct($vehicleFeatureCode = null, array $name = array(), $icon = null)
    {
        $this
            ->setVehicleFeatureCode($vehicleFeatureCode)
            ->setName($name)
            ->setIcon($icon);
    }
    /**
     * Get VehicleFeatureCode value
     * @return string|null
     */
    public function getVehicleFeatureCode()
    {
        return $this->VehicleFeatureCode;
    }
    /**
     * Set VehicleFeatureCode value
     * @param string $vehicleFeatureCode
     * @return \StructType\VehicleFeaturesStructure
     */
    public function setVehicleFeatureCode($vehicleFeatureCode = null)
    {
        // validation for constraint: string
        if (!is_null($vehicleFeatureCode) && !is_string($vehicleFeatureCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vehicleFeatureCode)), __LINE__);
        }
        $this->VehicleFeatureCode = $vehicleFeatureCode;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\NaturalLanguageStringStructure[]|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure[] $name
     * @return \StructType\VehicleFeaturesStructure
     */
    public function setName(array $name = array())
    {
        foreach ($name as $vehicleFeaturesStructureNameItem) {
            // validation for constraint: itemType
            if (!$vehicleFeaturesStructureNameItem instanceof \StructType\NaturalLanguageStringStructure) {
                throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($vehicleFeaturesStructureNameItem) ? get_class($vehicleFeaturesStructureNameItem) : gettype($vehicleFeaturesStructureNameItem)), __LINE__);
            }
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Add item to Name value
     * @throws \InvalidArgumentException
     * @param \StructType\NaturalLanguageStringStructure $item
     * @return \StructType\VehicleFeaturesStructure
     */
    public function addToName(\StructType\NaturalLanguageStringStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NaturalLanguageStringStructure) {
            throw new \InvalidArgumentException(sprintf('The Name property can only contain items of \StructType\NaturalLanguageStringStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Name[] = $item;
        return $this;
    }
    /**
     * Get Icon value
     * @return string|null
     */
    public function getIcon()
    {
        return $this->Icon;
    }
    /**
     * Set Icon value
     * @param string $icon
     * @return \StructType\VehicleFeaturesStructure
     */
    public function setIcon($icon = null)
    {
        // validation for constraint: string
        if (!is_null($icon) && !is_string($icon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($icon)), __LINE__);
        }
        $this->Icon = $icon;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleFeaturesStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
