<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleFeaturesDeliveryStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Response with Vehicle Features available to make requests.
 * @subpackage Structs
 */
class VehicleFeaturesDeliveryStructure extends AbstractDiscoveryDeliveryStructure
{
    /**
     * The VehicleFeature
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: VehicleFeature
     * @var \StructType\VehicleFeaturesStructure[]
     */
    public $VehicleFeature;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * The version
     * Meta informations extracted from the WSDL
     * - default: 2.0
     * - documentation: Version number of response. Fixed. | A string indicating the versioin of a SIRI data structure.
     * @var string
     */
    public $version;
    /**
     * Constructor method for VehicleFeaturesDeliveryStructure
     * @uses VehicleFeaturesDeliveryStructure::setVehicleFeature()
     * @uses VehicleFeaturesDeliveryStructure::setExtensions()
     * @uses VehicleFeaturesDeliveryStructure::setVersion()
     * @param \StructType\VehicleFeaturesStructure[] $vehicleFeature
     * @param \StructType\ExtensionsStructure $extensions
     * @param string $version
     */
    public function __construct(array $vehicleFeature = array(), \StructType\ExtensionsStructure $extensions = null, $version = '2.0')
    {
        $this
            ->setVehicleFeature($vehicleFeature)
            ->setExtensions($extensions)
            ->setVersion($version);
    }
    /**
     * Get VehicleFeature value
     * @return \StructType\VehicleFeaturesStructure[]|null
     */
    public function getVehicleFeature()
    {
        return $this->VehicleFeature;
    }
    /**
     * Set VehicleFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleFeaturesStructure[] $vehicleFeature
     * @return \StructType\VehicleFeaturesDeliveryStructure
     */
    public function setVehicleFeature(array $vehicleFeature = array())
    {
        foreach ($vehicleFeature as $vehicleFeaturesDeliveryStructureVehicleFeatureItem) {
            // validation for constraint: itemType
            if (!$vehicleFeaturesDeliveryStructureVehicleFeatureItem instanceof \StructType\VehicleFeaturesStructure) {
                throw new \InvalidArgumentException(sprintf('The VehicleFeature property can only contain items of \StructType\VehicleFeaturesStructure, "%s" given', is_object($vehicleFeaturesDeliveryStructureVehicleFeatureItem) ? get_class($vehicleFeaturesDeliveryStructureVehicleFeatureItem) : gettype($vehicleFeaturesDeliveryStructureVehicleFeatureItem)), __LINE__);
            }
        }
        $this->VehicleFeature = $vehicleFeature;
        return $this;
    }
    /**
     * Add item to VehicleFeature value
     * @throws \InvalidArgumentException
     * @param \StructType\VehicleFeaturesStructure $item
     * @return \StructType\VehicleFeaturesDeliveryStructure
     */
    public function addToVehicleFeature(\StructType\VehicleFeaturesStructure $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VehicleFeaturesStructure) {
            throw new \InvalidArgumentException(sprintf('The VehicleFeature property can only contain items of \StructType\VehicleFeaturesStructure, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->VehicleFeature[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\VehicleFeaturesDeliveryStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Get version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param string $version
     * @return \StructType\VehicleFeaturesDeliveryStructure
     */
    public function setVersion($version = '2.0')
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleFeaturesDeliveryStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
