<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VehicleCharacteristics StructType
 * @subpackage Structs
 */
class VehicleCharacteristics extends AbstractStructBase
{
    /**
     * The fuelType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fuelType;
    /**
     * The loadType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $loadType;
    /**
     * The vehicleEquipment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vehicleEquipment;
    /**
     * The vehicleType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $vehicleType;
    /**
     * The vehicleUsage
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vehicleUsage;
    /**
     * The grossWeightCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\GrossWeightCharacteristic[]
     */
    public $grossWeightCharacteristic;
    /**
     * The heightCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\HeightCharacteristic[]
     */
    public $heightCharacteristic;
    /**
     * The lengthCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\LengthCharacteristic[]
     */
    public $lengthCharacteristic;
    /**
     * The widthCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\WidthCharacteristic[]
     */
    public $widthCharacteristic;
    /**
     * The heaviestAxleWeightCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\HeaviestAxleWeightCharacteristic[]
     */
    public $heaviestAxleWeightCharacteristic;
    /**
     * The numberOfAxlesCharacteristic
     * Meta informations extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\NumberOfAxlesCharacteristic[]
     */
    public $numberOfAxlesCharacteristic;
    /**
     * The vehicleCharacteristicsExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $vehicleCharacteristicsExtension;
    /**
     * Constructor method for VehicleCharacteristics
     * @uses VehicleCharacteristics::setFuelType()
     * @uses VehicleCharacteristics::setLoadType()
     * @uses VehicleCharacteristics::setVehicleEquipment()
     * @uses VehicleCharacteristics::setVehicleType()
     * @uses VehicleCharacteristics::setVehicleUsage()
     * @uses VehicleCharacteristics::setGrossWeightCharacteristic()
     * @uses VehicleCharacteristics::setHeightCharacteristic()
     * @uses VehicleCharacteristics::setLengthCharacteristic()
     * @uses VehicleCharacteristics::setWidthCharacteristic()
     * @uses VehicleCharacteristics::setHeaviestAxleWeightCharacteristic()
     * @uses VehicleCharacteristics::setNumberOfAxlesCharacteristic()
     * @uses VehicleCharacteristics::setVehicleCharacteristicsExtension()
     * @param string $fuelType
     * @param string $loadType
     * @param string $vehicleEquipment
     * @param string[] $vehicleType
     * @param string $vehicleUsage
     * @param \StructType\GrossWeightCharacteristic[] $grossWeightCharacteristic
     * @param \StructType\HeightCharacteristic[] $heightCharacteristic
     * @param \StructType\LengthCharacteristic[] $lengthCharacteristic
     * @param \StructType\WidthCharacteristic[] $widthCharacteristic
     * @param \StructType\HeaviestAxleWeightCharacteristic[] $heaviestAxleWeightCharacteristic
     * @param \StructType\NumberOfAxlesCharacteristic[] $numberOfAxlesCharacteristic
     * @param \StructType\ExtensionType $vehicleCharacteristicsExtension
     */
    public function __construct($fuelType = null, $loadType = null, $vehicleEquipment = null, array $vehicleType = array(), $vehicleUsage = null, array $grossWeightCharacteristic = array(), array $heightCharacteristic = array(), array $lengthCharacteristic = array(), array $widthCharacteristic = array(), array $heaviestAxleWeightCharacteristic = array(), array $numberOfAxlesCharacteristic = array(), \StructType\ExtensionType $vehicleCharacteristicsExtension = null)
    {
        $this
            ->setFuelType($fuelType)
            ->setLoadType($loadType)
            ->setVehicleEquipment($vehicleEquipment)
            ->setVehicleType($vehicleType)
            ->setVehicleUsage($vehicleUsage)
            ->setGrossWeightCharacteristic($grossWeightCharacteristic)
            ->setHeightCharacteristic($heightCharacteristic)
            ->setLengthCharacteristic($lengthCharacteristic)
            ->setWidthCharacteristic($widthCharacteristic)
            ->setHeaviestAxleWeightCharacteristic($heaviestAxleWeightCharacteristic)
            ->setNumberOfAxlesCharacteristic($numberOfAxlesCharacteristic)
            ->setVehicleCharacteristicsExtension($vehicleCharacteristicsExtension);
    }
    /**
     * Get fuelType value
     * @return string|null
     */
    public function getFuelType()
    {
        return $this->fuelType;
    }
    /**
     * Set fuelType value
     * @uses \EnumType\FuelTypeEnum::valueIsValid()
     * @uses \EnumType\FuelTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fuelType
     * @return \StructType\VehicleCharacteristics
     */
    public function setFuelType($fuelType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FuelTypeEnum::valueIsValid($fuelType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fuelType, implode(', ', \EnumType\FuelTypeEnum::getValidValues())), __LINE__);
        }
        $this->fuelType = $fuelType;
        return $this;
    }
    /**
     * Get loadType value
     * @return string|null
     */
    public function getLoadType()
    {
        return $this->loadType;
    }
    /**
     * Set loadType value
     * @uses \EnumType\LoadTypeEnum::valueIsValid()
     * @uses \EnumType\LoadTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $loadType
     * @return \StructType\VehicleCharacteristics
     */
    public function setLoadType($loadType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\LoadTypeEnum::valueIsValid($loadType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $loadType, implode(', ', \EnumType\LoadTypeEnum::getValidValues())), __LINE__);
        }
        $this->loadType = $loadType;
        return $this;
    }
    /**
     * Get vehicleEquipment value
     * @return string|null
     */
    public function getVehicleEquipment()
    {
        return $this->vehicleEquipment;
    }
    /**
     * Set vehicleEquipment value
     * @uses \EnumType\VehicleEquipmentEnum::valueIsValid()
     * @uses \EnumType\VehicleEquipmentEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleEquipment
     * @return \StructType\VehicleCharacteristics
     */
    public function setVehicleEquipment($vehicleEquipment = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleEquipmentEnum::valueIsValid($vehicleEquipment)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleEquipment, implode(', ', \EnumType\VehicleEquipmentEnum::getValidValues())), __LINE__);
        }
        $this->vehicleEquipment = $vehicleEquipment;
        return $this;
    }
    /**
     * Get vehicleType value
     * @return string[]|null
     */
    public function getVehicleType()
    {
        return $this->vehicleType;
    }
    /**
     * Set vehicleType value
     * @uses \EnumType\VehicleTypeEnum::valueIsValid()
     * @uses \EnumType\VehicleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $vehicleType
     * @return \StructType\VehicleCharacteristics
     */
    public function setVehicleType(array $vehicleType = array())
    {
        $invalidValues = array();
        foreach ($vehicleType as $vehicleCharacteristicsVehicleTypeItem) {
            if (!\EnumType\VehicleTypeEnum::valueIsValid($vehicleCharacteristicsVehicleTypeItem)) {
                $invalidValues[] = var_export($vehicleCharacteristicsVehicleTypeItem, true);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\VehicleTypeEnum::getValidValues())), __LINE__);
        }
        $this->vehicleType = $vehicleType;
        return $this;
    }
    /**
     * Add item to vehicleType value
     * @uses \EnumType\VehicleTypeEnum::valueIsValid()
     * @uses \EnumType\VehicleTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToVehicleType($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleTypeEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\VehicleTypeEnum::getValidValues())), __LINE__);
        }
        $this->vehicleType[] = $item;
        return $this;
    }
    /**
     * Get vehicleUsage value
     * @return string|null
     */
    public function getVehicleUsage()
    {
        return $this->vehicleUsage;
    }
    /**
     * Set vehicleUsage value
     * @uses \EnumType\VehicleUsageEnum::valueIsValid()
     * @uses \EnumType\VehicleUsageEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vehicleUsage
     * @return \StructType\VehicleCharacteristics
     */
    public function setVehicleUsage($vehicleUsage = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VehicleUsageEnum::valueIsValid($vehicleUsage)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vehicleUsage, implode(', ', \EnumType\VehicleUsageEnum::getValidValues())), __LINE__);
        }
        $this->vehicleUsage = $vehicleUsage;
        return $this;
    }
    /**
     * Get grossWeightCharacteristic value
     * @return \StructType\GrossWeightCharacteristic[]|null
     */
    public function getGrossWeightCharacteristic()
    {
        return $this->grossWeightCharacteristic;
    }
    /**
     * Set grossWeightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\GrossWeightCharacteristic[] $grossWeightCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setGrossWeightCharacteristic(array $grossWeightCharacteristic = array())
    {
        foreach ($grossWeightCharacteristic as $vehicleCharacteristicsGrossWeightCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsGrossWeightCharacteristicItem instanceof \StructType\GrossWeightCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The grossWeightCharacteristic property can only contain items of \StructType\GrossWeightCharacteristic, "%s" given', is_object($vehicleCharacteristicsGrossWeightCharacteristicItem) ? get_class($vehicleCharacteristicsGrossWeightCharacteristicItem) : gettype($vehicleCharacteristicsGrossWeightCharacteristicItem)), __LINE__);
            }
        }
        $this->grossWeightCharacteristic = $grossWeightCharacteristic;
        return $this;
    }
    /**
     * Add item to grossWeightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\GrossWeightCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToGrossWeightCharacteristic(\StructType\GrossWeightCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GrossWeightCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The grossWeightCharacteristic property can only contain items of \StructType\GrossWeightCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->grossWeightCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get heightCharacteristic value
     * @return \StructType\HeightCharacteristic[]|null
     */
    public function getHeightCharacteristic()
    {
        return $this->heightCharacteristic;
    }
    /**
     * Set heightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\HeightCharacteristic[] $heightCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setHeightCharacteristic(array $heightCharacteristic = array())
    {
        foreach ($heightCharacteristic as $vehicleCharacteristicsHeightCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsHeightCharacteristicItem instanceof \StructType\HeightCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The heightCharacteristic property can only contain items of \StructType\HeightCharacteristic, "%s" given', is_object($vehicleCharacteristicsHeightCharacteristicItem) ? get_class($vehicleCharacteristicsHeightCharacteristicItem) : gettype($vehicleCharacteristicsHeightCharacteristicItem)), __LINE__);
            }
        }
        $this->heightCharacteristic = $heightCharacteristic;
        return $this;
    }
    /**
     * Add item to heightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\HeightCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToHeightCharacteristic(\StructType\HeightCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HeightCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The heightCharacteristic property can only contain items of \StructType\HeightCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->heightCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get lengthCharacteristic value
     * @return \StructType\LengthCharacteristic[]|null
     */
    public function getLengthCharacteristic()
    {
        return $this->lengthCharacteristic;
    }
    /**
     * Set lengthCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthCharacteristic[] $lengthCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setLengthCharacteristic(array $lengthCharacteristic = array())
    {
        foreach ($lengthCharacteristic as $vehicleCharacteristicsLengthCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsLengthCharacteristicItem instanceof \StructType\LengthCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The lengthCharacteristic property can only contain items of \StructType\LengthCharacteristic, "%s" given', is_object($vehicleCharacteristicsLengthCharacteristicItem) ? get_class($vehicleCharacteristicsLengthCharacteristicItem) : gettype($vehicleCharacteristicsLengthCharacteristicItem)), __LINE__);
            }
        }
        $this->lengthCharacteristic = $lengthCharacteristic;
        return $this;
    }
    /**
     * Add item to lengthCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\LengthCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToLengthCharacteristic(\StructType\LengthCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LengthCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The lengthCharacteristic property can only contain items of \StructType\LengthCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->lengthCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get widthCharacteristic value
     * @return \StructType\WidthCharacteristic[]|null
     */
    public function getWidthCharacteristic()
    {
        return $this->widthCharacteristic;
    }
    /**
     * Set widthCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\WidthCharacteristic[] $widthCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setWidthCharacteristic(array $widthCharacteristic = array())
    {
        foreach ($widthCharacteristic as $vehicleCharacteristicsWidthCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsWidthCharacteristicItem instanceof \StructType\WidthCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The widthCharacteristic property can only contain items of \StructType\WidthCharacteristic, "%s" given', is_object($vehicleCharacteristicsWidthCharacteristicItem) ? get_class($vehicleCharacteristicsWidthCharacteristicItem) : gettype($vehicleCharacteristicsWidthCharacteristicItem)), __LINE__);
            }
        }
        $this->widthCharacteristic = $widthCharacteristic;
        return $this;
    }
    /**
     * Add item to widthCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\WidthCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToWidthCharacteristic(\StructType\WidthCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WidthCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The widthCharacteristic property can only contain items of \StructType\WidthCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->widthCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get heaviestAxleWeightCharacteristic value
     * @return \StructType\HeaviestAxleWeightCharacteristic[]|null
     */
    public function getHeaviestAxleWeightCharacteristic()
    {
        return $this->heaviestAxleWeightCharacteristic;
    }
    /**
     * Set heaviestAxleWeightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\HeaviestAxleWeightCharacteristic[] $heaviestAxleWeightCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setHeaviestAxleWeightCharacteristic(array $heaviestAxleWeightCharacteristic = array())
    {
        foreach ($heaviestAxleWeightCharacteristic as $vehicleCharacteristicsHeaviestAxleWeightCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsHeaviestAxleWeightCharacteristicItem instanceof \StructType\HeaviestAxleWeightCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The heaviestAxleWeightCharacteristic property can only contain items of \StructType\HeaviestAxleWeightCharacteristic, "%s" given', is_object($vehicleCharacteristicsHeaviestAxleWeightCharacteristicItem) ? get_class($vehicleCharacteristicsHeaviestAxleWeightCharacteristicItem) : gettype($vehicleCharacteristicsHeaviestAxleWeightCharacteristicItem)), __LINE__);
            }
        }
        $this->heaviestAxleWeightCharacteristic = $heaviestAxleWeightCharacteristic;
        return $this;
    }
    /**
     * Add item to heaviestAxleWeightCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\HeaviestAxleWeightCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToHeaviestAxleWeightCharacteristic(\StructType\HeaviestAxleWeightCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HeaviestAxleWeightCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The heaviestAxleWeightCharacteristic property can only contain items of \StructType\HeaviestAxleWeightCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->heaviestAxleWeightCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get numberOfAxlesCharacteristic value
     * @return \StructType\NumberOfAxlesCharacteristic[]|null
     */
    public function getNumberOfAxlesCharacteristic()
    {
        return $this->numberOfAxlesCharacteristic;
    }
    /**
     * Set numberOfAxlesCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\NumberOfAxlesCharacteristic[] $numberOfAxlesCharacteristic
     * @return \StructType\VehicleCharacteristics
     */
    public function setNumberOfAxlesCharacteristic(array $numberOfAxlesCharacteristic = array())
    {
        foreach ($numberOfAxlesCharacteristic as $vehicleCharacteristicsNumberOfAxlesCharacteristicItem) {
            // validation for constraint: itemType
            if (!$vehicleCharacteristicsNumberOfAxlesCharacteristicItem instanceof \StructType\NumberOfAxlesCharacteristic) {
                throw new \InvalidArgumentException(sprintf('The numberOfAxlesCharacteristic property can only contain items of \StructType\NumberOfAxlesCharacteristic, "%s" given', is_object($vehicleCharacteristicsNumberOfAxlesCharacteristicItem) ? get_class($vehicleCharacteristicsNumberOfAxlesCharacteristicItem) : gettype($vehicleCharacteristicsNumberOfAxlesCharacteristicItem)), __LINE__);
            }
        }
        $this->numberOfAxlesCharacteristic = $numberOfAxlesCharacteristic;
        return $this;
    }
    /**
     * Add item to numberOfAxlesCharacteristic value
     * @throws \InvalidArgumentException
     * @param \StructType\NumberOfAxlesCharacteristic $item
     * @return \StructType\VehicleCharacteristics
     */
    public function addToNumberOfAxlesCharacteristic(\StructType\NumberOfAxlesCharacteristic $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NumberOfAxlesCharacteristic) {
            throw new \InvalidArgumentException(sprintf('The numberOfAxlesCharacteristic property can only contain items of \StructType\NumberOfAxlesCharacteristic, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->numberOfAxlesCharacteristic[] = $item;
        return $this;
    }
    /**
     * Get vehicleCharacteristicsExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getVehicleCharacteristicsExtension()
    {
        return $this->vehicleCharacteristicsExtension;
    }
    /**
     * Set vehicleCharacteristicsExtension value
     * @param \StructType\ExtensionType $vehicleCharacteristicsExtension
     * @return \StructType\VehicleCharacteristics
     */
    public function setVehicleCharacteristicsExtension(\StructType\ExtensionType $vehicleCharacteristicsExtension = null)
    {
        $this->vehicleCharacteristicsExtension = $vehicleCharacteristicsExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VehicleCharacteristics
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
