<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for values StructType
 * @subpackage Structs
 */
class Values extends AbstractStructBase
{
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\MultilingualStringValue[]
     */
    public $value;
    /**
     * Constructor method for values
     * @uses Values::setValue()
     * @param \StructType\MultilingualStringValue[] $value
     */
    public function __construct(array $value = array())
    {
        $this
            ->setValue($value);
    }
    /**
     * Get value value
     * @return \StructType\MultilingualStringValue[]|null
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @throws \InvalidArgumentException
     * @param \StructType\MultilingualStringValue[] $value
     * @return \StructType\Values
     */
    public function setValue(array $value = array())
    {
        foreach ($value as $valuesValueItem) {
            // validation for constraint: itemType
            if (!$valuesValueItem instanceof \StructType\MultilingualStringValue) {
                throw new \InvalidArgumentException(sprintf('The value property can only contain items of \StructType\MultilingualStringValue, "%s" given', is_object($valuesValueItem) ? get_class($valuesValueItem) : gettype($valuesValueItem)), __LINE__);
            }
        }
        $this->value = $value;
        return $this;
    }
    /**
     * Add item to value value
     * @throws \InvalidArgumentException
     * @param \StructType\MultilingualStringValue $item
     * @return \StructType\Values
     */
    public function addToValue(\StructType\MultilingualStringValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MultilingualStringValue) {
            throw new \InvalidArgumentException(sprintf('The value property can only contain items of \StructType\MultilingualStringValue, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->value[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Values
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
