<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnknownExtensionsErrorStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Unknown Extensions Error:. +SIRI v2.0.
 * @subpackage Structs
 */
class UnknownExtensionsErrorStructure extends ErrorCodeStructure
{
    /**
     * The ExtensionName
     * Meta informations extracted from the WSDL
     * - documentation: Name of the unknown encountered extensions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ExtensionName;
    /**
     * Constructor method for UnknownExtensionsErrorStructure
     * @uses UnknownExtensionsErrorStructure::setExtensionName()
     * @param string[] $extensionName
     */
    public function __construct(array $extensionName = array())
    {
        $this
            ->setExtensionName($extensionName);
    }
    /**
     * Get ExtensionName value
     * @return string[]|null
     */
    public function getExtensionName()
    {
        return $this->ExtensionName;
    }
    /**
     * Set ExtensionName value
     * @throws \InvalidArgumentException
     * @param string[] $extensionName
     * @return \StructType\UnknownExtensionsErrorStructure
     */
    public function setExtensionName(array $extensionName = array())
    {
        foreach ($extensionName as $unknownExtensionsErrorStructureExtensionNameItem) {
            // validation for constraint: itemType
            if (!is_string($unknownExtensionsErrorStructureExtensionNameItem)) {
                throw new \InvalidArgumentException(sprintf('The ExtensionName property can only contain items of string, "%s" given', is_object($unknownExtensionsErrorStructureExtensionNameItem) ? get_class($unknownExtensionsErrorStructureExtensionNameItem) : gettype($unknownExtensionsErrorStructureExtensionNameItem)), __LINE__);
            }
        }
        $this->ExtensionName = $extensionName;
        return $this;
    }
    /**
     * Add item to ExtensionName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\UnknownExtensionsErrorStructure
     */
    public function addToExtensionName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The ExtensionName property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ExtensionName[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnknownExtensionsErrorStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
