<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransitInformation StructType
 * @subpackage Structs
 */
class TransitInformation extends NonRoadEventInformation
{
    /**
     * The transitServiceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transitServiceInformation;
    /**
     * The transitServiceType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $transitServiceType;
    /**
     * The journeyDestination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $journeyDestination;
    /**
     * The journeyOrigin
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MultilingualString
     */
    public $journeyOrigin;
    /**
     * The journeyReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 1024
     * @var string
     */
    public $journeyReference;
    /**
     * The scheduledDepartureTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $scheduledDepartureTime;
    /**
     * The transitInformationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $transitInformationExtension;
    /**
     * Constructor method for TransitInformation
     * @uses TransitInformation::setTransitServiceInformation()
     * @uses TransitInformation::setTransitServiceType()
     * @uses TransitInformation::setJourneyDestination()
     * @uses TransitInformation::setJourneyOrigin()
     * @uses TransitInformation::setJourneyReference()
     * @uses TransitInformation::setScheduledDepartureTime()
     * @uses TransitInformation::setTransitInformationExtension()
     * @param string $transitServiceInformation
     * @param string $transitServiceType
     * @param \StructType\MultilingualString $journeyDestination
     * @param \StructType\MultilingualString $journeyOrigin
     * @param string $journeyReference
     * @param string $scheduledDepartureTime
     * @param \StructType\ExtensionType $transitInformationExtension
     */
    public function __construct($transitServiceInformation = null, $transitServiceType = null, \StructType\MultilingualString $journeyDestination = null, \StructType\MultilingualString $journeyOrigin = null, $journeyReference = null, $scheduledDepartureTime = null, \StructType\ExtensionType $transitInformationExtension = null)
    {
        $this
            ->setTransitServiceInformation($transitServiceInformation)
            ->setTransitServiceType($transitServiceType)
            ->setJourneyDestination($journeyDestination)
            ->setJourneyOrigin($journeyOrigin)
            ->setJourneyReference($journeyReference)
            ->setScheduledDepartureTime($scheduledDepartureTime)
            ->setTransitInformationExtension($transitInformationExtension);
    }
    /**
     * Get transitServiceInformation value
     * @return string
     */
    public function getTransitServiceInformation()
    {
        return $this->transitServiceInformation;
    }
    /**
     * Set transitServiceInformation value
     * @uses \EnumType\TransitServiceInformationEnum::valueIsValid()
     * @uses \EnumType\TransitServiceInformationEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transitServiceInformation
     * @return \StructType\TransitInformation
     */
    public function setTransitServiceInformation($transitServiceInformation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransitServiceInformationEnum::valueIsValid($transitServiceInformation)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transitServiceInformation, implode(', ', \EnumType\TransitServiceInformationEnum::getValidValues())), __LINE__);
        }
        $this->transitServiceInformation = $transitServiceInformation;
        return $this;
    }
    /**
     * Get transitServiceType value
     * @return string
     */
    public function getTransitServiceType()
    {
        return $this->transitServiceType;
    }
    /**
     * Set transitServiceType value
     * @uses \EnumType\TransitServiceTypeEnum::valueIsValid()
     * @uses \EnumType\TransitServiceTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transitServiceType
     * @return \StructType\TransitInformation
     */
    public function setTransitServiceType($transitServiceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TransitServiceTypeEnum::valueIsValid($transitServiceType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $transitServiceType, implode(', ', \EnumType\TransitServiceTypeEnum::getValidValues())), __LINE__);
        }
        $this->transitServiceType = $transitServiceType;
        return $this;
    }
    /**
     * Get journeyDestination value
     * @return \StructType\MultilingualString|null
     */
    public function getJourneyDestination()
    {
        return $this->journeyDestination;
    }
    /**
     * Set journeyDestination value
     * @param \StructType\MultilingualString $journeyDestination
     * @return \StructType\TransitInformation
     */
    public function setJourneyDestination(\StructType\MultilingualString $journeyDestination = null)
    {
        $this->journeyDestination = $journeyDestination;
        return $this;
    }
    /**
     * Get journeyOrigin value
     * @return \StructType\MultilingualString|null
     */
    public function getJourneyOrigin()
    {
        return $this->journeyOrigin;
    }
    /**
     * Set journeyOrigin value
     * @param \StructType\MultilingualString $journeyOrigin
     * @return \StructType\TransitInformation
     */
    public function setJourneyOrigin(\StructType\MultilingualString $journeyOrigin = null)
    {
        $this->journeyOrigin = $journeyOrigin;
        return $this;
    }
    /**
     * Get journeyReference value
     * @return string|null
     */
    public function getJourneyReference()
    {
        return $this->journeyReference;
    }
    /**
     * Set journeyReference value
     * @param string $journeyReference
     * @return \StructType\TransitInformation
     */
    public function setJourneyReference($journeyReference = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($journeyReference) && strlen($journeyReference) > 1024) || (is_array($journeyReference) && count($journeyReference) > 1024)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 1024 element(s) or a scalar of 1024 character(s) at most, "%d" length given', is_scalar($journeyReference) ? strlen($journeyReference) : count($journeyReference)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($journeyReference) && !is_string($journeyReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($journeyReference)), __LINE__);
        }
        $this->journeyReference = $journeyReference;
        return $this;
    }
    /**
     * Get scheduledDepartureTime value
     * @return string|null
     */
    public function getScheduledDepartureTime()
    {
        return $this->scheduledDepartureTime;
    }
    /**
     * Set scheduledDepartureTime value
     * @param string $scheduledDepartureTime
     * @return \StructType\TransitInformation
     */
    public function setScheduledDepartureTime($scheduledDepartureTime = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDepartureTime) && !is_string($scheduledDepartureTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDepartureTime)), __LINE__);
        }
        $this->scheduledDepartureTime = $scheduledDepartureTime;
        return $this;
    }
    /**
     * Get transitInformationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTransitInformationExtension()
    {
        return $this->transitInformationExtension;
    }
    /**
     * Set transitInformationExtension value
     * @param \StructType\ExtensionType $transitInformationExtension
     * @return \StructType\TransitInformation
     */
    public function setTransitInformationExtension(\StructType\ExtensionType $transitInformationExtension = null)
    {
        $this->transitInformationExtension = $transitInformationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TransitInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
