<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficSpeed StructType
 * @subpackage Structs
 */
class TrafficSpeed extends TrafficValue
{
    /**
     * The averageVehicleSpeed
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $averageVehicleSpeed;
    /**
     * The speedPercentile
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\SpeedPercentile
     */
    public $speedPercentile;
    /**
     * The trafficSpeedExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficSpeedExtension;
    /**
     * Constructor method for TrafficSpeed
     * @uses TrafficSpeed::setAverageVehicleSpeed()
     * @uses TrafficSpeed::setSpeedPercentile()
     * @uses TrafficSpeed::setTrafficSpeedExtension()
     * @param float $averageVehicleSpeed
     * @param \StructType\SpeedPercentile $speedPercentile
     * @param \StructType\ExtensionType $trafficSpeedExtension
     */
    public function __construct($averageVehicleSpeed = null, \StructType\SpeedPercentile $speedPercentile = null, \StructType\ExtensionType $trafficSpeedExtension = null)
    {
        $this
            ->setAverageVehicleSpeed($averageVehicleSpeed)
            ->setSpeedPercentile($speedPercentile)
            ->setTrafficSpeedExtension($trafficSpeedExtension);
    }
    /**
     * Get averageVehicleSpeed value
     * @return float|null
     */
    public function getAverageVehicleSpeed()
    {
        return $this->averageVehicleSpeed;
    }
    /**
     * Set averageVehicleSpeed value
     * @param float $averageVehicleSpeed
     * @return \StructType\TrafficSpeed
     */
    public function setAverageVehicleSpeed($averageVehicleSpeed = null)
    {
        $this->averageVehicleSpeed = $averageVehicleSpeed;
        return $this;
    }
    /**
     * Get speedPercentile value
     * @return \StructType\SpeedPercentile|null
     */
    public function getSpeedPercentile()
    {
        return $this->speedPercentile;
    }
    /**
     * Set speedPercentile value
     * @param \StructType\SpeedPercentile $speedPercentile
     * @return \StructType\TrafficSpeed
     */
    public function setSpeedPercentile(\StructType\SpeedPercentile $speedPercentile = null)
    {
        $this->speedPercentile = $speedPercentile;
        return $this;
    }
    /**
     * Get trafficSpeedExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficSpeedExtension()
    {
        return $this->trafficSpeedExtension;
    }
    /**
     * Set trafficSpeedExtension value
     * @param \StructType\ExtensionType $trafficSpeedExtension
     * @return \StructType\TrafficSpeed
     */
    public function setTrafficSpeedExtension(\StructType\ExtensionType $trafficSpeedExtension = null)
    {
        $this->trafficSpeedExtension = $trafficSpeedExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficSpeed
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
