<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficFlow StructType
 * @subpackage Structs
 */
class TrafficFlow extends TrafficValue
{
    /**
     * The axleFlow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $axleFlow;
    /**
     * The pcuFlow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $pcuFlow;
    /**
     * The percentageLongVehicles
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $percentageLongVehicles;
    /**
     * The vehicleFlow
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $vehicleFlow;
    /**
     * The trafficFlowExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficFlowExtension;
    /**
     * Constructor method for TrafficFlow
     * @uses TrafficFlow::setAxleFlow()
     * @uses TrafficFlow::setPcuFlow()
     * @uses TrafficFlow::setPercentageLongVehicles()
     * @uses TrafficFlow::setVehicleFlow()
     * @uses TrafficFlow::setTrafficFlowExtension()
     * @param int $axleFlow
     * @param int $pcuFlow
     * @param float $percentageLongVehicles
     * @param int $vehicleFlow
     * @param \StructType\ExtensionType $trafficFlowExtension
     */
    public function __construct($axleFlow = null, $pcuFlow = null, $percentageLongVehicles = null, $vehicleFlow = null, \StructType\ExtensionType $trafficFlowExtension = null)
    {
        $this
            ->setAxleFlow($axleFlow)
            ->setPcuFlow($pcuFlow)
            ->setPercentageLongVehicles($percentageLongVehicles)
            ->setVehicleFlow($vehicleFlow)
            ->setTrafficFlowExtension($trafficFlowExtension);
    }
    /**
     * Get axleFlow value
     * @return int|null
     */
    public function getAxleFlow()
    {
        return $this->axleFlow;
    }
    /**
     * Set axleFlow value
     * @param int $axleFlow
     * @return \StructType\TrafficFlow
     */
    public function setAxleFlow($axleFlow = null)
    {
        // validation for constraint: int
        if (!is_null($axleFlow) && !is_numeric($axleFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($axleFlow)), __LINE__);
        }
        $this->axleFlow = $axleFlow;
        return $this;
    }
    /**
     * Get pcuFlow value
     * @return int|null
     */
    public function getPcuFlow()
    {
        return $this->pcuFlow;
    }
    /**
     * Set pcuFlow value
     * @param int $pcuFlow
     * @return \StructType\TrafficFlow
     */
    public function setPcuFlow($pcuFlow = null)
    {
        // validation for constraint: int
        if (!is_null($pcuFlow) && !is_numeric($pcuFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pcuFlow)), __LINE__);
        }
        $this->pcuFlow = $pcuFlow;
        return $this;
    }
    /**
     * Get percentageLongVehicles value
     * @return float|null
     */
    public function getPercentageLongVehicles()
    {
        return $this->percentageLongVehicles;
    }
    /**
     * Set percentageLongVehicles value
     * @param float $percentageLongVehicles
     * @return \StructType\TrafficFlow
     */
    public function setPercentageLongVehicles($percentageLongVehicles = null)
    {
        $this->percentageLongVehicles = $percentageLongVehicles;
        return $this;
    }
    /**
     * Get vehicleFlow value
     * @return int|null
     */
    public function getVehicleFlow()
    {
        return $this->vehicleFlow;
    }
    /**
     * Set vehicleFlow value
     * @param int $vehicleFlow
     * @return \StructType\TrafficFlow
     */
    public function setVehicleFlow($vehicleFlow = null)
    {
        // validation for constraint: int
        if (!is_null($vehicleFlow) && !is_numeric($vehicleFlow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vehicleFlow)), __LINE__);
        }
        $this->vehicleFlow = $vehicleFlow;
        return $this;
    }
    /**
     * Get trafficFlowExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficFlowExtension()
    {
        return $this->trafficFlowExtension;
    }
    /**
     * Set trafficFlowExtension value
     * @param \StructType\ExtensionType $trafficFlowExtension
     * @return \StructType\TrafficFlow
     */
    public function setTrafficFlowExtension(\StructType\ExtensionType $trafficFlowExtension = null)
    {
        $this->trafficFlowExtension = $trafficFlowExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficFlow
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
