<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TrafficConcentration StructType
 * @subpackage Structs
 */
class TrafficConcentration extends TrafficValue
{
    /**
     * The concentration
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $concentration;
    /**
     * The occupancy
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $occupancy;
    /**
     * The trafficConcentrationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $trafficConcentrationExtension;
    /**
     * Constructor method for TrafficConcentration
     * @uses TrafficConcentration::setConcentration()
     * @uses TrafficConcentration::setOccupancy()
     * @uses TrafficConcentration::setTrafficConcentrationExtension()
     * @param int $concentration
     * @param float $occupancy
     * @param \StructType\ExtensionType $trafficConcentrationExtension
     */
    public function __construct($concentration = null, $occupancy = null, \StructType\ExtensionType $trafficConcentrationExtension = null)
    {
        $this
            ->setConcentration($concentration)
            ->setOccupancy($occupancy)
            ->setTrafficConcentrationExtension($trafficConcentrationExtension);
    }
    /**
     * Get concentration value
     * @return int|null
     */
    public function getConcentration()
    {
        return $this->concentration;
    }
    /**
     * Set concentration value
     * @param int $concentration
     * @return \StructType\TrafficConcentration
     */
    public function setConcentration($concentration = null)
    {
        // validation for constraint: int
        if (!is_null($concentration) && !is_numeric($concentration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($concentration)), __LINE__);
        }
        $this->concentration = $concentration;
        return $this;
    }
    /**
     * Get occupancy value
     * @return float|null
     */
    public function getOccupancy()
    {
        return $this->occupancy;
    }
    /**
     * Set occupancy value
     * @param float $occupancy
     * @return \StructType\TrafficConcentration
     */
    public function setOccupancy($occupancy = null)
    {
        $this->occupancy = $occupancy;
        return $this;
    }
    /**
     * Get trafficConcentrationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTrafficConcentrationExtension()
    {
        return $this->trafficConcentrationExtension;
    }
    /**
     * Set trafficConcentrationExtension value
     * @param \StructType\ExtensionType $trafficConcentrationExtension
     * @return \StructType\TrafficConcentration
     */
    public function setTrafficConcentrationExtension(\StructType\ExtensionType $trafficConcentrationExtension = null)
    {
        $this->trafficConcentrationExtension = $trafficConcentrationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TrafficConcentration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
