<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TpegLinearLocation StructType
 * @subpackage Structs
 */
class TpegLinearLocation extends AbstractStructBase
{
    /**
     * The tpegDirection
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegDirection;
    /**
     * The tpegLinearLocationType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tpegLinearLocationType;
    /**
     * The to
     * @var \StructType\TpegPoint
     */
    public $to;
    /**
     * The from
     * @var \StructType\TpegPoint
     */
    public $from;
    /**
     * The tpegLinearLocationExtension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ExtensionType
     */
    public $tpegLinearLocationExtension;
    /**
     * Constructor method for TpegLinearLocation
     * @uses TpegLinearLocation::setTpegDirection()
     * @uses TpegLinearLocation::setTpegLinearLocationType()
     * @uses TpegLinearLocation::setTo()
     * @uses TpegLinearLocation::setFrom()
     * @uses TpegLinearLocation::setTpegLinearLocationExtension()
     * @param string $tpegDirection
     * @param string $tpegLinearLocationType
     * @param \StructType\TpegPoint $to
     * @param \StructType\TpegPoint $from
     * @param \StructType\ExtensionType $tpegLinearLocationExtension
     */
    public function __construct($tpegDirection = null, $tpegLinearLocationType = null, \StructType\TpegPoint $to = null, \StructType\TpegPoint $from = null, \StructType\ExtensionType $tpegLinearLocationExtension = null)
    {
        $this
            ->setTpegDirection($tpegDirection)
            ->setTpegLinearLocationType($tpegLinearLocationType)
            ->setTo($to)
            ->setFrom($from)
            ->setTpegLinearLocationExtension($tpegLinearLocationExtension);
    }
    /**
     * Get tpegDirection value
     * @return string
     */
    public function getTpegDirection()
    {
        return $this->tpegDirection;
    }
    /**
     * Set tpegDirection value
     * @uses \EnumType\TpegLoc02DirectionTypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc02DirectionTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegDirection
     * @return \StructType\TpegLinearLocation
     */
    public function setTpegDirection($tpegDirection = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc02DirectionTypeEnum::valueIsValid($tpegDirection)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegDirection, implode(', ', \EnumType\TpegLoc02DirectionTypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegDirection = $tpegDirection;
        return $this;
    }
    /**
     * Get tpegLinearLocationType value
     * @return string
     */
    public function getTpegLinearLocationType()
    {
        return $this->tpegLinearLocationType;
    }
    /**
     * Set tpegLinearLocationType value
     * @uses \EnumType\TpegLoc01LinearLocationSubtypeEnum::valueIsValid()
     * @uses \EnumType\TpegLoc01LinearLocationSubtypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tpegLinearLocationType
     * @return \StructType\TpegLinearLocation
     */
    public function setTpegLinearLocationType($tpegLinearLocationType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TpegLoc01LinearLocationSubtypeEnum::valueIsValid($tpegLinearLocationType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tpegLinearLocationType, implode(', ', \EnumType\TpegLoc01LinearLocationSubtypeEnum::getValidValues())), __LINE__);
        }
        $this->tpegLinearLocationType = $tpegLinearLocationType;
        return $this;
    }
    /**
     * Get to value
     * @return \StructType\TpegPoint|null
     */
    public function getTo()
    {
        return $this->to;
    }
    /**
     * Set to value
     * @param \StructType\TpegPoint $to
     * @return \StructType\TpegLinearLocation
     */
    public function setTo(\StructType\TpegPoint $to = null)
    {
        $this->to = $to;
        return $this;
    }
    /**
     * Get from value
     * @return \StructType\TpegPoint|null
     */
    public function getFrom()
    {
        return $this->from;
    }
    /**
     * Set from value
     * @param \StructType\TpegPoint $from
     * @return \StructType\TpegLinearLocation
     */
    public function setFrom(\StructType\TpegPoint $from = null)
    {
        $this->from = $from;
        return $this;
    }
    /**
     * Get tpegLinearLocationExtension value
     * @return \StructType\ExtensionType|null
     */
    public function getTpegLinearLocationExtension()
    {
        return $this->tpegLinearLocationExtension;
    }
    /**
     * Set tpegLinearLocationExtension value
     * @param \StructType\ExtensionType $tpegLinearLocationExtension
     * @return \StructType\TpegLinearLocation
     */
    public function setTpegLinearLocationExtension(\StructType\ExtensionType $tpegLinearLocationExtension = null)
    {
        $this->tpegLinearLocationExtension = $tpegLinearLocationExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TpegLinearLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
