<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TopicFiltering StructType
 * Meta informations extracted from the WSDL
 * - documentation: Filtering Capabilities. | Filtering Capabilities. | Available Filtering Capabilities. | Available Filtering Capabilities. | Topic Filtering Capabilities. | Filtering Capabilities. | Whether results can be filtered by Connection link.
 * Default is ' true'. | Filtering Capabilities. | Filtering Capabilities. | Filtering Capabilities. | Filtering Capabilities.
 * @subpackage Structs
 */
class TopicFiltering extends AbstractStructBase
{
    /**
     * The FilterByValidityPeriod
     * Meta informations extracted from the WSDL
     * - ref: FilterByValidityPeriod
     * @var bool
     */
    public $FilterByValidityPeriod;
    /**
     * The FilterByOperatorRef
     * Meta informations extracted from the WSDL
     * - ref: FilterByOperatorRef
     * @var bool
     */
    public $FilterByOperatorRef;
    /**
     * The FilterByLineRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByLineRef
     * @var bool
     */
    public $FilterByLineRef;
    /**
     * The FilterByVersionRef
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by TIMETABLE VERSION Default is 'true'. | Whether results can be filtered by TIMETABLE VERSION Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByVersionRef;
    /**
     * The DefaultPreviewInterval
     * Meta informations extracted from the WSDL
     * - default: PT60M
     * - documentation: Preview interval available for estimations. | Default preview interval. Default is 60 minutes. | Default preview interval. Default is 60 minutes. | Default preview horizon used. | Default preview interval. Default is 60 minutes. |
     * Default preview interval. Default is 60 minutes. | Default preview interval. Default is 60 minutes. | Limited version of duration. Must be positive. | Limited version of duration that allows for precise time arithmetic. Only Month, Day, Hour, Minute
     * Second terms should be used. Milliseconds should not be used. Year should not be used. Negative values allowed. e.g. PT1004199059S", "PT130S", "PT2M10S", "P1DT2S", "-P1DT2S".
     * - minOccurs: 0
     * @var string
     */
    public $DefaultPreviewInterval;
    /**
     * The FilterByMonitoringRef
     * Meta informations extracted from the WSDL
     * - ref: FilterByMonitoringRef
     * @var bool
     */
    public $FilterByMonitoringRef;
    /**
     * The FilterByDirectionRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByDirectionRef
     * @var bool
     */
    public $FilterByDirectionRef;
    /**
     * The ByStartTime
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether a start time other than now can be specified for preview interval. Default is 'truet.
     * - minOccurs: 0
     * @var bool
     */
    public $ByStartTime;
    /**
     * The FilterByDestination
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByDestination
     * @var bool
     */
    public $FilterByDestination;
    /**
     * The FilterByVisitType
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by VistitType, e.g. arrivals, departures. Default True.
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByVisitType;
    /**
     * The FilterByVehicleMonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by Vehicle Monitoring Fixed as 'true'.
     * - fixed: true
     * @var bool
     */
    public $FilterByVehicleMonitoringRef;
    /**
     * The FilterByVehicleRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByVehicleRef
     * @var bool
     */
    public $FilterByVehicleRef;
    /**
     * The FilterByConnectionLinkRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByConnectionLinkRef
     * @var bool
     */
    public $FilterByConnectionLinkRef;
    /**
     * The FilterByJourney
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by journey.
     * - fixed: true
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByJourney;
    /**
     * The FilterByTime
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by time Filter of Connection. Default is ' true'.
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByTime;
    /**
     * The FilterByInfoChannel
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by InfoChannel, departures. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByInfoChannel;
    /**
     * The FilterByFacilityRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByFacilityRef
     * @var bool
     */
    public $FilterByFacilityRef;
    /**
     * The FilterByLocationRef
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by location. Fixed as 'true'. | Whether results can be filtered by location. Fixed as 'true'.
     * - fixed: true
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByLocationRef;
    /**
     * The FilterByStopPointRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByStopPointRef
     * @var bool
     */
    public $FilterByStopPointRef;
    /**
     * The FilterByVehicleJourneyRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByVehicleJourneyRef
     * @var bool
     */
    public $FilterByVehicleJourneyRef;
    /**
     * The FilterByInterchangeRef
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: FilterByInterchangeRef
     * @var bool
     */
    public $FilterByInterchangeRef;
    /**
     * The FilterBySpecificNeed
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by Specific Needs. Default is 'true'. | Whether results can be filtered by Specific Needs. Default is 'true'.
     * - minOccurs: 0
     * @var bool
     */
    public $FilterBySpecificNeed;
    /**
     * The FilterByMode
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by MODE. Default is true.. (+SIRI v2.0)
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByMode;
    /**
     * The FilterByNetworkRef
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by NETWORKs. Default is 'true'. (+SIRI v2.0)
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByNetworkRef;
    /**
     * The FilterByStopPlaceRef
     * Meta informations extracted from the WSDL
     * - documentation: Whether results can be filtered by STOP PLACE identifvier. Default is 'false'. (+SIRI v2.0)
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByStopPlaceRef;
    /**
     * The FilterByKeyword
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether results can be filtered by Keywords. Default is 'false'
     * - minOccurs: 0
     * @var bool
     */
    public $FilterByKeyword;
    /**
     * Constructor method for TopicFiltering
     * @uses TopicFiltering::setFilterByValidityPeriod()
     * @uses TopicFiltering::setFilterByOperatorRef()
     * @uses TopicFiltering::setFilterByLineRef()
     * @uses TopicFiltering::setFilterByVersionRef()
     * @uses TopicFiltering::setDefaultPreviewInterval()
     * @uses TopicFiltering::setFilterByMonitoringRef()
     * @uses TopicFiltering::setFilterByDirectionRef()
     * @uses TopicFiltering::setByStartTime()
     * @uses TopicFiltering::setFilterByDestination()
     * @uses TopicFiltering::setFilterByVisitType()
     * @uses TopicFiltering::setFilterByVehicleMonitoringRef()
     * @uses TopicFiltering::setFilterByVehicleRef()
     * @uses TopicFiltering::setFilterByConnectionLinkRef()
     * @uses TopicFiltering::setFilterByJourney()
     * @uses TopicFiltering::setFilterByTime()
     * @uses TopicFiltering::setFilterByInfoChannel()
     * @uses TopicFiltering::setFilterByFacilityRef()
     * @uses TopicFiltering::setFilterByLocationRef()
     * @uses TopicFiltering::setFilterByStopPointRef()
     * @uses TopicFiltering::setFilterByVehicleJourneyRef()
     * @uses TopicFiltering::setFilterByInterchangeRef()
     * @uses TopicFiltering::setFilterBySpecificNeed()
     * @uses TopicFiltering::setFilterByMode()
     * @uses TopicFiltering::setFilterByNetworkRef()
     * @uses TopicFiltering::setFilterByStopPlaceRef()
     * @uses TopicFiltering::setFilterByKeyword()
     * @param bool $filterByValidityPeriod
     * @param bool $filterByOperatorRef
     * @param bool $filterByLineRef
     * @param bool $filterByVersionRef
     * @param string $defaultPreviewInterval
     * @param bool $filterByMonitoringRef
     * @param bool $filterByDirectionRef
     * @param bool $byStartTime
     * @param bool $filterByDestination
     * @param bool $filterByVisitType
     * @param bool $filterByVehicleMonitoringRef
     * @param bool $filterByVehicleRef
     * @param bool $filterByConnectionLinkRef
     * @param bool $filterByJourney
     * @param bool $filterByTime
     * @param bool $filterByInfoChannel
     * @param bool $filterByFacilityRef
     * @param bool $filterByLocationRef
     * @param bool $filterByStopPointRef
     * @param bool $filterByVehicleJourneyRef
     * @param bool $filterByInterchangeRef
     * @param bool $filterBySpecificNeed
     * @param bool $filterByMode
     * @param bool $filterByNetworkRef
     * @param bool $filterByStopPlaceRef
     * @param bool $filterByKeyword
     */
    public function __construct($filterByValidityPeriod = null, $filterByOperatorRef = null, $filterByLineRef = null, $filterByVersionRef = true, $defaultPreviewInterval = 'PT60M', $filterByMonitoringRef = null, $filterByDirectionRef = null, $byStartTime = true, $filterByDestination = null, $filterByVisitType = true, $filterByVehicleMonitoringRef = null, $filterByVehicleRef = null, $filterByConnectionLinkRef = null, $filterByJourney = null, $filterByTime = true, $filterByInfoChannel = true, $filterByFacilityRef = null, $filterByLocationRef = null, $filterByStopPointRef = null, $filterByVehicleJourneyRef = null, $filterByInterchangeRef = null, $filterBySpecificNeed = true, $filterByMode = null, $filterByNetworkRef = null, $filterByStopPlaceRef = null, $filterByKeyword = true)
    {
        $this
            ->setFilterByValidityPeriod($filterByValidityPeriod)
            ->setFilterByOperatorRef($filterByOperatorRef)
            ->setFilterByLineRef($filterByLineRef)
            ->setFilterByVersionRef($filterByVersionRef)
            ->setDefaultPreviewInterval($defaultPreviewInterval)
            ->setFilterByMonitoringRef($filterByMonitoringRef)
            ->setFilterByDirectionRef($filterByDirectionRef)
            ->setByStartTime($byStartTime)
            ->setFilterByDestination($filterByDestination)
            ->setFilterByVisitType($filterByVisitType)
            ->setFilterByVehicleMonitoringRef($filterByVehicleMonitoringRef)
            ->setFilterByVehicleRef($filterByVehicleRef)
            ->setFilterByConnectionLinkRef($filterByConnectionLinkRef)
            ->setFilterByJourney($filterByJourney)
            ->setFilterByTime($filterByTime)
            ->setFilterByInfoChannel($filterByInfoChannel)
            ->setFilterByFacilityRef($filterByFacilityRef)
            ->setFilterByLocationRef($filterByLocationRef)
            ->setFilterByStopPointRef($filterByStopPointRef)
            ->setFilterByVehicleJourneyRef($filterByVehicleJourneyRef)
            ->setFilterByInterchangeRef($filterByInterchangeRef)
            ->setFilterBySpecificNeed($filterBySpecificNeed)
            ->setFilterByMode($filterByMode)
            ->setFilterByNetworkRef($filterByNetworkRef)
            ->setFilterByStopPlaceRef($filterByStopPlaceRef)
            ->setFilterByKeyword($filterByKeyword);
    }
    /**
     * Get FilterByValidityPeriod value
     * @return bool|null
     */
    public function getFilterByValidityPeriod()
    {
        return $this->FilterByValidityPeriod;
    }
    /**
     * Set FilterByValidityPeriod value
     * @param bool $filterByValidityPeriod
     * @return \StructType\TopicFiltering
     */
    public function setFilterByValidityPeriod($filterByValidityPeriod = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByValidityPeriod) && !is_bool($filterByValidityPeriod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByValidityPeriod)), __LINE__);
        }
        $this->FilterByValidityPeriod = $filterByValidityPeriod;
        return $this;
    }
    /**
     * Get FilterByOperatorRef value
     * @return bool|null
     */
    public function getFilterByOperatorRef()
    {
        return $this->FilterByOperatorRef;
    }
    /**
     * Set FilterByOperatorRef value
     * @param bool $filterByOperatorRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByOperatorRef($filterByOperatorRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByOperatorRef) && !is_bool($filterByOperatorRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByOperatorRef)), __LINE__);
        }
        $this->FilterByOperatorRef = $filterByOperatorRef;
        return $this;
    }
    /**
     * Get FilterByLineRef value
     * @return bool|null
     */
    public function getFilterByLineRef()
    {
        return $this->FilterByLineRef;
    }
    /**
     * Set FilterByLineRef value
     * @param bool $filterByLineRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByLineRef($filterByLineRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByLineRef) && !is_bool($filterByLineRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByLineRef)), __LINE__);
        }
        $this->FilterByLineRef = $filterByLineRef;
        return $this;
    }
    /**
     * Get FilterByVersionRef value
     * @return bool|null
     */
    public function getFilterByVersionRef()
    {
        return $this->FilterByVersionRef;
    }
    /**
     * Set FilterByVersionRef value
     * @param bool $filterByVersionRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByVersionRef($filterByVersionRef = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterByVersionRef) && !is_bool($filterByVersionRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByVersionRef)), __LINE__);
        }
        $this->FilterByVersionRef = $filterByVersionRef;
        return $this;
    }
    /**
     * Get DefaultPreviewInterval value
     * @return string|null
     */
    public function getDefaultPreviewInterval()
    {
        return $this->DefaultPreviewInterval;
    }
    /**
     * Set DefaultPreviewInterval value
     * @param string $defaultPreviewInterval
     * @return \StructType\TopicFiltering
     */
    public function setDefaultPreviewInterval($defaultPreviewInterval = 'PT60M')
    {
        // validation for constraint: string
        if (!is_null($defaultPreviewInterval) && !is_string($defaultPreviewInterval)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($defaultPreviewInterval)), __LINE__);
        }
        $this->DefaultPreviewInterval = $defaultPreviewInterval;
        return $this;
    }
    /**
     * Get FilterByMonitoringRef value
     * @return bool|null
     */
    public function getFilterByMonitoringRef()
    {
        return $this->FilterByMonitoringRef;
    }
    /**
     * Set FilterByMonitoringRef value
     * @param bool $filterByMonitoringRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByMonitoringRef($filterByMonitoringRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByMonitoringRef) && !is_bool($filterByMonitoringRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByMonitoringRef)), __LINE__);
        }
        $this->FilterByMonitoringRef = $filterByMonitoringRef;
        return $this;
    }
    /**
     * Get FilterByDirectionRef value
     * @return bool|null
     */
    public function getFilterByDirectionRef()
    {
        return $this->FilterByDirectionRef;
    }
    /**
     * Set FilterByDirectionRef value
     * @param bool $filterByDirectionRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByDirectionRef($filterByDirectionRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByDirectionRef) && !is_bool($filterByDirectionRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByDirectionRef)), __LINE__);
        }
        $this->FilterByDirectionRef = $filterByDirectionRef;
        return $this;
    }
    /**
     * Get ByStartTime value
     * @return bool|null
     */
    public function getByStartTime()
    {
        return $this->ByStartTime;
    }
    /**
     * Set ByStartTime value
     * @param bool $byStartTime
     * @return \StructType\TopicFiltering
     */
    public function setByStartTime($byStartTime = true)
    {
        // validation for constraint: boolean
        if (!is_null($byStartTime) && !is_bool($byStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($byStartTime)), __LINE__);
        }
        $this->ByStartTime = $byStartTime;
        return $this;
    }
    /**
     * Get FilterByDestination value
     * @return bool|null
     */
    public function getFilterByDestination()
    {
        return $this->FilterByDestination;
    }
    /**
     * Set FilterByDestination value
     * @param bool $filterByDestination
     * @return \StructType\TopicFiltering
     */
    public function setFilterByDestination($filterByDestination = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByDestination) && !is_bool($filterByDestination)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByDestination)), __LINE__);
        }
        $this->FilterByDestination = $filterByDestination;
        return $this;
    }
    /**
     * Get FilterByVisitType value
     * @return bool|null
     */
    public function getFilterByVisitType()
    {
        return $this->FilterByVisitType;
    }
    /**
     * Set FilterByVisitType value
     * @param bool $filterByVisitType
     * @return \StructType\TopicFiltering
     */
    public function setFilterByVisitType($filterByVisitType = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterByVisitType) && !is_bool($filterByVisitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByVisitType)), __LINE__);
        }
        $this->FilterByVisitType = $filterByVisitType;
        return $this;
    }
    /**
     * Get FilterByVehicleMonitoringRef value
     * @return bool|null
     */
    public function getFilterByVehicleMonitoringRef()
    {
        return $this->FilterByVehicleMonitoringRef;
    }
    /**
     * Set FilterByVehicleMonitoringRef value
     * @param bool $filterByVehicleMonitoringRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByVehicleMonitoringRef($filterByVehicleMonitoringRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByVehicleMonitoringRef) && !is_bool($filterByVehicleMonitoringRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByVehicleMonitoringRef)), __LINE__);
        }
        $this->FilterByVehicleMonitoringRef = $filterByVehicleMonitoringRef;
        return $this;
    }
    /**
     * Get FilterByVehicleRef value
     * @return bool|null
     */
    public function getFilterByVehicleRef()
    {
        return $this->FilterByVehicleRef;
    }
    /**
     * Set FilterByVehicleRef value
     * @param bool $filterByVehicleRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByVehicleRef($filterByVehicleRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByVehicleRef) && !is_bool($filterByVehicleRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByVehicleRef)), __LINE__);
        }
        $this->FilterByVehicleRef = $filterByVehicleRef;
        return $this;
    }
    /**
     * Get FilterByConnectionLinkRef value
     * @return bool|null
     */
    public function getFilterByConnectionLinkRef()
    {
        return $this->FilterByConnectionLinkRef;
    }
    /**
     * Set FilterByConnectionLinkRef value
     * @param bool $filterByConnectionLinkRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByConnectionLinkRef($filterByConnectionLinkRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByConnectionLinkRef) && !is_bool($filterByConnectionLinkRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByConnectionLinkRef)), __LINE__);
        }
        $this->FilterByConnectionLinkRef = $filterByConnectionLinkRef;
        return $this;
    }
    /**
     * Get FilterByJourney value
     * @return bool|null
     */
    public function getFilterByJourney()
    {
        return $this->FilterByJourney;
    }
    /**
     * Set FilterByJourney value
     * @param bool $filterByJourney
     * @return \StructType\TopicFiltering
     */
    public function setFilterByJourney($filterByJourney = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByJourney) && !is_bool($filterByJourney)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByJourney)), __LINE__);
        }
        $this->FilterByJourney = $filterByJourney;
        return $this;
    }
    /**
     * Get FilterByTime value
     * @return bool|null
     */
    public function getFilterByTime()
    {
        return $this->FilterByTime;
    }
    /**
     * Set FilterByTime value
     * @param bool $filterByTime
     * @return \StructType\TopicFiltering
     */
    public function setFilterByTime($filterByTime = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterByTime) && !is_bool($filterByTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByTime)), __LINE__);
        }
        $this->FilterByTime = $filterByTime;
        return $this;
    }
    /**
     * Get FilterByInfoChannel value
     * @return bool|null
     */
    public function getFilterByInfoChannel()
    {
        return $this->FilterByInfoChannel;
    }
    /**
     * Set FilterByInfoChannel value
     * @param bool $filterByInfoChannel
     * @return \StructType\TopicFiltering
     */
    public function setFilterByInfoChannel($filterByInfoChannel = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterByInfoChannel) && !is_bool($filterByInfoChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByInfoChannel)), __LINE__);
        }
        $this->FilterByInfoChannel = $filterByInfoChannel;
        return $this;
    }
    /**
     * Get FilterByFacilityRef value
     * @return bool|null
     */
    public function getFilterByFacilityRef()
    {
        return $this->FilterByFacilityRef;
    }
    /**
     * Set FilterByFacilityRef value
     * @param bool $filterByFacilityRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByFacilityRef($filterByFacilityRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByFacilityRef) && !is_bool($filterByFacilityRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByFacilityRef)), __LINE__);
        }
        $this->FilterByFacilityRef = $filterByFacilityRef;
        return $this;
    }
    /**
     * Get FilterByLocationRef value
     * @return bool|null
     */
    public function getFilterByLocationRef()
    {
        return $this->FilterByLocationRef;
    }
    /**
     * Set FilterByLocationRef value
     * @param bool $filterByLocationRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByLocationRef($filterByLocationRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByLocationRef) && !is_bool($filterByLocationRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByLocationRef)), __LINE__);
        }
        $this->FilterByLocationRef = $filterByLocationRef;
        return $this;
    }
    /**
     * Get FilterByStopPointRef value
     * @return bool|null
     */
    public function getFilterByStopPointRef()
    {
        return $this->FilterByStopPointRef;
    }
    /**
     * Set FilterByStopPointRef value
     * @param bool $filterByStopPointRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByStopPointRef($filterByStopPointRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByStopPointRef) && !is_bool($filterByStopPointRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByStopPointRef)), __LINE__);
        }
        $this->FilterByStopPointRef = $filterByStopPointRef;
        return $this;
    }
    /**
     * Get FilterByVehicleJourneyRef value
     * @return bool|null
     */
    public function getFilterByVehicleJourneyRef()
    {
        return $this->FilterByVehicleJourneyRef;
    }
    /**
     * Set FilterByVehicleJourneyRef value
     * @param bool $filterByVehicleJourneyRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByVehicleJourneyRef($filterByVehicleJourneyRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByVehicleJourneyRef) && !is_bool($filterByVehicleJourneyRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByVehicleJourneyRef)), __LINE__);
        }
        $this->FilterByVehicleJourneyRef = $filterByVehicleJourneyRef;
        return $this;
    }
    /**
     * Get FilterByInterchangeRef value
     * @return bool|null
     */
    public function getFilterByInterchangeRef()
    {
        return $this->FilterByInterchangeRef;
    }
    /**
     * Set FilterByInterchangeRef value
     * @param bool $filterByInterchangeRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByInterchangeRef($filterByInterchangeRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByInterchangeRef) && !is_bool($filterByInterchangeRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByInterchangeRef)), __LINE__);
        }
        $this->FilterByInterchangeRef = $filterByInterchangeRef;
        return $this;
    }
    /**
     * Get FilterBySpecificNeed value
     * @return bool|null
     */
    public function getFilterBySpecificNeed()
    {
        return $this->FilterBySpecificNeed;
    }
    /**
     * Set FilterBySpecificNeed value
     * @param bool $filterBySpecificNeed
     * @return \StructType\TopicFiltering
     */
    public function setFilterBySpecificNeed($filterBySpecificNeed = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterBySpecificNeed) && !is_bool($filterBySpecificNeed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterBySpecificNeed)), __LINE__);
        }
        $this->FilterBySpecificNeed = $filterBySpecificNeed;
        return $this;
    }
    /**
     * Get FilterByMode value
     * @return bool|null
     */
    public function getFilterByMode()
    {
        return $this->FilterByMode;
    }
    /**
     * Set FilterByMode value
     * @param bool $filterByMode
     * @return \StructType\TopicFiltering
     */
    public function setFilterByMode($filterByMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByMode) && !is_bool($filterByMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByMode)), __LINE__);
        }
        $this->FilterByMode = $filterByMode;
        return $this;
    }
    /**
     * Get FilterByNetworkRef value
     * @return bool|null
     */
    public function getFilterByNetworkRef()
    {
        return $this->FilterByNetworkRef;
    }
    /**
     * Set FilterByNetworkRef value
     * @param bool $filterByNetworkRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByNetworkRef($filterByNetworkRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByNetworkRef) && !is_bool($filterByNetworkRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByNetworkRef)), __LINE__);
        }
        $this->FilterByNetworkRef = $filterByNetworkRef;
        return $this;
    }
    /**
     * Get FilterByStopPlaceRef value
     * @return bool|null
     */
    public function getFilterByStopPlaceRef()
    {
        return $this->FilterByStopPlaceRef;
    }
    /**
     * Set FilterByStopPlaceRef value
     * @param bool $filterByStopPlaceRef
     * @return \StructType\TopicFiltering
     */
    public function setFilterByStopPlaceRef($filterByStopPlaceRef = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterByStopPlaceRef) && !is_bool($filterByStopPlaceRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByStopPlaceRef)), __LINE__);
        }
        $this->FilterByStopPlaceRef = $filterByStopPlaceRef;
        return $this;
    }
    /**
     * Get FilterByKeyword value
     * @return bool|null
     */
    public function getFilterByKeyword()
    {
        return $this->FilterByKeyword;
    }
    /**
     * Set FilterByKeyword value
     * @param bool $filterByKeyword
     * @return \StructType\TopicFiltering
     */
    public function setFilterByKeyword($filterByKeyword = true)
    {
        // validation for constraint: boolean
        if (!is_null($filterByKeyword) && !is_bool($filterByKeyword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($filterByKeyword)), __LINE__);
        }
        $this->FilterByKeyword = $filterByKeyword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TopicFiltering
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
