<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimetabledStopVisitStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Timetabled Visit of a VEHICLE to a stop. May provide information about the arrival, the departure or both.
 * @subpackage Structs
 */
class TimetabledStopVisitStructure extends AbstractIdentifiedItemStructure
{
    /**
     * The MonitoringRef
     * Meta informations extracted from the WSDL
     * - documentation: Reference to a stop monitoring point / LOGICAL DISPLAY to which Stop Visit applies.
     * @var \StructType\MonitoringRefStructure
     */
    public $MonitoringRef;
    /**
     * The TargetedVehicleJourney
     * Meta informations extracted from the WSDL
     * - ref: TargetedVehicleJourney
     * @var \StructType\TargetedVehicleJourneyStructure
     */
    public $TargetedVehicleJourney;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for TimetabledStopVisitStructure
     * @uses TimetabledStopVisitStructure::setMonitoringRef()
     * @uses TimetabledStopVisitStructure::setTargetedVehicleJourney()
     * @uses TimetabledStopVisitStructure::setExtensions()
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @param \StructType\TargetedVehicleJourneyStructure $targetedVehicleJourney
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct(\StructType\MonitoringRefStructure $monitoringRef = null, \StructType\TargetedVehicleJourneyStructure $targetedVehicleJourney = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setMonitoringRef($monitoringRef)
            ->setTargetedVehicleJourney($targetedVehicleJourney)
            ->setExtensions($extensions);
    }
    /**
     * Get MonitoringRef value
     * @return \StructType\MonitoringRefStructure|null
     */
    public function getMonitoringRef()
    {
        return $this->MonitoringRef;
    }
    /**
     * Set MonitoringRef value
     * @param \StructType\MonitoringRefStructure $monitoringRef
     * @return \StructType\TimetabledStopVisitStructure
     */
    public function setMonitoringRef(\StructType\MonitoringRefStructure $monitoringRef = null)
    {
        $this->MonitoringRef = $monitoringRef;
        return $this;
    }
    /**
     * Get TargetedVehicleJourney value
     * @return \StructType\TargetedVehicleJourneyStructure|null
     */
    public function getTargetedVehicleJourney()
    {
        return $this->TargetedVehicleJourney;
    }
    /**
     * Set TargetedVehicleJourney value
     * @param \StructType\TargetedVehicleJourneyStructure $targetedVehicleJourney
     * @return \StructType\TimetabledStopVisitStructure
     */
    public function setTargetedVehicleJourney(\StructType\TargetedVehicleJourneyStructure $targetedVehicleJourney = null)
    {
        $this->TargetedVehicleJourney = $targetedVehicleJourney;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\TimetabledStopVisitStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimetabledStopVisitStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
