<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminationResponseStatusStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for Status of termination response.
 * @subpackage Structs
 */
class TerminationResponseStatusStructure extends AbstractStructBase
{
    /**
     * The ResponseTimestamp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: ResponseTimestamp
     * @var string
     */
    public $ResponseTimestamp;
    /**
     * The RequestMessageRef
     * @var \StructType\MessageQualifierStructure
     */
    public $RequestMessageRef;
    /**
     * The SubscriberRef
     * @var \StructType\ParticipantRefStructure
     */
    public $SubscriberRef;
    /**
     * The SubscriptionFilterRef
     * @var \StructType\SubscriptionFilterRefStructure
     */
    public $SubscriptionFilterRef;
    /**
     * The SubscriptionRef
     * @var \StructType\SubscriptionQualifierStructure
     */
    public $SubscriptionRef;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - ref: Status
     * @var bool
     */
    public $Status;
    /**
     * The ErrorCondition
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ErrorCondition
     */
    public $ErrorCondition;
    /**
     * Constructor method for TerminationResponseStatusStructure
     * @uses TerminationResponseStatusStructure::setResponseTimestamp()
     * @uses TerminationResponseStatusStructure::setRequestMessageRef()
     * @uses TerminationResponseStatusStructure::setSubscriberRef()
     * @uses TerminationResponseStatusStructure::setSubscriptionFilterRef()
     * @uses TerminationResponseStatusStructure::setSubscriptionRef()
     * @uses TerminationResponseStatusStructure::setStatus()
     * @uses TerminationResponseStatusStructure::setErrorCondition()
     * @param string $responseTimestamp
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @param bool $status
     * @param \StructType\ErrorCondition $errorCondition
     */
    public function __construct($responseTimestamp = null, \StructType\MessageQualifierStructure $requestMessageRef = null, \StructType\ParticipantRefStructure $subscriberRef = null, \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null, \StructType\SubscriptionQualifierStructure $subscriptionRef = null, $status = null, \StructType\ErrorCondition $errorCondition = null)
    {
        $this
            ->setResponseTimestamp($responseTimestamp)
            ->setRequestMessageRef($requestMessageRef)
            ->setSubscriberRef($subscriberRef)
            ->setSubscriptionFilterRef($subscriptionFilterRef)
            ->setSubscriptionRef($subscriptionRef)
            ->setStatus($status)
            ->setErrorCondition($errorCondition);
    }
    /**
     * Get ResponseTimestamp value
     * @return string|null
     */
    public function getResponseTimestamp()
    {
        return $this->ResponseTimestamp;
    }
    /**
     * Set ResponseTimestamp value
     * @param string $responseTimestamp
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setResponseTimestamp($responseTimestamp = null)
    {
        // validation for constraint: string
        if (!is_null($responseTimestamp) && !is_string($responseTimestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($responseTimestamp)), __LINE__);
        }
        $this->ResponseTimestamp = $responseTimestamp;
        return $this;
    }
    /**
     * Get RequestMessageRef value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getRequestMessageRef()
    {
        return $this->RequestMessageRef;
    }
    /**
     * Set RequestMessageRef value
     * @param \StructType\MessageQualifierStructure $requestMessageRef
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setRequestMessageRef(\StructType\MessageQualifierStructure $requestMessageRef = null)
    {
        $this->RequestMessageRef = $requestMessageRef;
        return $this;
    }
    /**
     * Get SubscriberRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getSubscriberRef()
    {
        return $this->SubscriberRef;
    }
    /**
     * Set SubscriberRef value
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setSubscriberRef(\StructType\ParticipantRefStructure $subscriberRef = null)
    {
        $this->SubscriberRef = $subscriberRef;
        return $this;
    }
    /**
     * Get SubscriptionFilterRef value
     * @return \StructType\SubscriptionFilterRefStructure|null
     */
    public function getSubscriptionFilterRef()
    {
        return $this->SubscriptionFilterRef;
    }
    /**
     * Set SubscriptionFilterRef value
     * @param \StructType\SubscriptionFilterRefStructure $subscriptionFilterRef
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setSubscriptionFilterRef(\StructType\SubscriptionFilterRefStructure $subscriptionFilterRef = null)
    {
        $this->SubscriptionFilterRef = $subscriptionFilterRef;
        return $this;
    }
    /**
     * Get SubscriptionRef value
     * @return \StructType\SubscriptionQualifierStructure|null
     */
    public function getSubscriptionRef()
    {
        return $this->SubscriptionRef;
    }
    /**
     * Set SubscriptionRef value
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setSubscriptionRef(\StructType\SubscriptionQualifierStructure $subscriptionRef = null)
    {
        $this->SubscriptionRef = $subscriptionRef;
        return $this;
    }
    /**
     * Get Status value
     * @return bool|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param bool $status
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setStatus($status = null)
    {
        // validation for constraint: boolean
        if (!is_null($status) && !is_bool($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ErrorCondition value
     * @return \StructType\ErrorCondition|null
     */
    public function getErrorCondition()
    {
        return $this->ErrorCondition;
    }
    /**
     * Set ErrorCondition value
     * @param \StructType\ErrorCondition $errorCondition
     * @return \StructType\TerminationResponseStatusStructure
     */
    public function setErrorCondition(\StructType\ErrorCondition $errorCondition = null)
    {
        $this->ErrorCondition = $errorCondition;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminationResponseStatusStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
