<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TerminateSubscriptionRequestStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for request to terminate a subscription or subscriptions. | If request has been proxied by an intermediate aggregating system , tracking information relating to the original requestor. This allows the aggregation to be
 * stateless. +SIRI 2.0
 * @subpackage Structs
 */
class TerminateSubscriptionRequestStructure extends AuthenticatedRequestStructure
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $Address;
    /**
     * The RequestorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $RequestorRef;
    /**
     * The MessageIdentifier
     * @var \StructType\MessageQualifierStructure
     */
    public $MessageIdentifier;
    /**
     * The DelegatorAddress
     * Meta informations extracted from the WSDL
     * - documentation: Type for a endpoint.
     * @var string
     */
    public $DelegatorAddress;
    /**
     * The DelegatorRef
     * @var \StructType\ParticipantRefStructure
     */
    public $DelegatorRef;
    /**
     * The SubscriberRef
     * @var \StructType\ParticipantRefStructure
     */
    public $SubscriberRef;
    /**
     * The All
     * @var string
     */
    public $All;
    /**
     * The SubscriptionRef
     * @var \StructType\SubscriptionQualifierStructure
     */
    public $SubscriptionRef;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: Extensions
     * @var \StructType\ExtensionsStructure
     */
    public $Extensions;
    /**
     * Constructor method for TerminateSubscriptionRequestStructure
     * @uses TerminateSubscriptionRequestStructure::setAddress()
     * @uses TerminateSubscriptionRequestStructure::setRequestorRef()
     * @uses TerminateSubscriptionRequestStructure::setMessageIdentifier()
     * @uses TerminateSubscriptionRequestStructure::setDelegatorAddress()
     * @uses TerminateSubscriptionRequestStructure::setDelegatorRef()
     * @uses TerminateSubscriptionRequestStructure::setSubscriberRef()
     * @uses TerminateSubscriptionRequestStructure::setAll()
     * @uses TerminateSubscriptionRequestStructure::setSubscriptionRef()
     * @uses TerminateSubscriptionRequestStructure::setExtensions()
     * @param string $address
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @param string $delegatorAddress
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @param string $all
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @param \StructType\ExtensionsStructure $extensions
     */
    public function __construct($address = null, \StructType\ParticipantRefStructure $requestorRef = null, \StructType\MessageQualifierStructure $messageIdentifier = null, $delegatorAddress = null, \StructType\ParticipantRefStructure $delegatorRef = null, \StructType\ParticipantRefStructure $subscriberRef = null, $all = null, \StructType\SubscriptionQualifierStructure $subscriptionRef = null, \StructType\ExtensionsStructure $extensions = null)
    {
        $this
            ->setAddress($address)
            ->setRequestorRef($requestorRef)
            ->setMessageIdentifier($messageIdentifier)
            ->setDelegatorAddress($delegatorAddress)
            ->setDelegatorRef($delegatorRef)
            ->setSubscriberRef($subscriberRef)
            ->setAll($all)
            ->setSubscriptionRef($subscriptionRef)
            ->setExtensions($extensions);
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get RequestorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getRequestorRef()
    {
        return $this->RequestorRef;
    }
    /**
     * Set RequestorRef value
     * @param \StructType\ParticipantRefStructure $requestorRef
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setRequestorRef(\StructType\ParticipantRefStructure $requestorRef = null)
    {
        $this->RequestorRef = $requestorRef;
        return $this;
    }
    /**
     * Get MessageIdentifier value
     * @return \StructType\MessageQualifierStructure|null
     */
    public function getMessageIdentifier()
    {
        return $this->MessageIdentifier;
    }
    /**
     * Set MessageIdentifier value
     * @param \StructType\MessageQualifierStructure $messageIdentifier
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setMessageIdentifier(\StructType\MessageQualifierStructure $messageIdentifier = null)
    {
        $this->MessageIdentifier = $messageIdentifier;
        return $this;
    }
    /**
     * Get DelegatorAddress value
     * @return string|null
     */
    public function getDelegatorAddress()
    {
        return $this->DelegatorAddress;
    }
    /**
     * Set DelegatorAddress value
     * @param string $delegatorAddress
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setDelegatorAddress($delegatorAddress = null)
    {
        // validation for constraint: string
        if (!is_null($delegatorAddress) && !is_string($delegatorAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($delegatorAddress)), __LINE__);
        }
        $this->DelegatorAddress = $delegatorAddress;
        return $this;
    }
    /**
     * Get DelegatorRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getDelegatorRef()
    {
        return $this->DelegatorRef;
    }
    /**
     * Set DelegatorRef value
     * @param \StructType\ParticipantRefStructure $delegatorRef
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setDelegatorRef(\StructType\ParticipantRefStructure $delegatorRef = null)
    {
        $this->DelegatorRef = $delegatorRef;
        return $this;
    }
    /**
     * Get SubscriberRef value
     * @return \StructType\ParticipantRefStructure|null
     */
    public function getSubscriberRef()
    {
        return $this->SubscriberRef;
    }
    /**
     * Set SubscriberRef value
     * @param \StructType\ParticipantRefStructure $subscriberRef
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setSubscriberRef(\StructType\ParticipantRefStructure $subscriberRef = null)
    {
        $this->SubscriberRef = $subscriberRef;
        return $this;
    }
    /**
     * Get All value
     * @return string|null
     */
    public function getAll()
    {
        return $this->All;
    }
    /**
     * Set All value
     * @uses \EnumType\EmptyType::valueIsValid()
     * @uses \EnumType\EmptyType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $all
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setAll($all = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EmptyType::valueIsValid($all)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $all, implode(', ', \EnumType\EmptyType::getValidValues())), __LINE__);
        }
        $this->All = $all;
        return $this;
    }
    /**
     * Get SubscriptionRef value
     * @return \StructType\SubscriptionQualifierStructure|null
     */
    public function getSubscriptionRef()
    {
        return $this->SubscriptionRef;
    }
    /**
     * Set SubscriptionRef value
     * @param \StructType\SubscriptionQualifierStructure $subscriptionRef
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setSubscriptionRef(\StructType\SubscriptionQualifierStructure $subscriptionRef = null)
    {
        $this->SubscriptionRef = $subscriptionRef;
        return $this;
    }
    /**
     * Get Extensions value
     * @return \StructType\ExtensionsStructure|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @param \StructType\ExtensionsStructure $extensions
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public function setExtensions(\StructType\ExtensionsStructure $extensions = null)
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TerminateSubscriptionRequestStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
