<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SuitabilityStructure StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type for of a specific SUITABILITY.
 * @subpackage Structs
 */
class SuitabilityStructure extends AbstractStructBase
{
    /**
     * The Suitable
     * Meta informations extracted from the WSDL
     * - documentation: Whether the Facility is suitable.
     * @var string
     */
    public $Suitable;
    /**
     * The UserNeed
     * Meta informations extracted from the WSDL
     * - documentation: USER NEED for which SUITABILITY is specified.
     * @var \StructType\UserNeedStructure
     */
    public $UserNeed;
    /**
     * Constructor method for SuitabilityStructure
     * @uses SuitabilityStructure::setSuitable()
     * @uses SuitabilityStructure::setUserNeed()
     * @param string $suitable
     * @param \StructType\UserNeedStructure $userNeed
     */
    public function __construct($suitable = null, \StructType\UserNeedStructure $userNeed = null)
    {
        $this
            ->setSuitable($suitable)
            ->setUserNeed($userNeed);
    }
    /**
     * Get Suitable value
     * @return string|null
     */
    public function getSuitable()
    {
        return $this->Suitable;
    }
    /**
     * Set Suitable value
     * @uses \EnumType\SuitabilityEnumeration::valueIsValid()
     * @uses \EnumType\SuitabilityEnumeration::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $suitable
     * @return \StructType\SuitabilityStructure
     */
    public function setSuitable($suitable = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SuitabilityEnumeration::valueIsValid($suitable)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $suitable, implode(', ', \EnumType\SuitabilityEnumeration::getValidValues())), __LINE__);
        }
        $this->Suitable = $suitable;
        return $this;
    }
    /**
     * Get UserNeed value
     * @return \StructType\UserNeedStructure|null
     */
    public function getUserNeed()
    {
        return $this->UserNeed;
    }
    /**
     * Set UserNeed value
     * @param \StructType\UserNeedStructure $userNeed
     * @return \StructType\SuitabilityStructure
     */
    public function setUserNeed(\StructType\UserNeedStructure $userNeed = null)
    {
        $this->UserNeed = $userNeed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SuitabilityStructure
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
