<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionPolicy StructType
 * Meta informations extracted from the WSDL
 * - documentation: Subscription Policy capabilities.
 * @subpackage Structs
 */
class SubscriptionPolicy extends AbstractStructBase
{
    /**
     * The HasIncrementalUpdates
     * Meta informations extracted from the WSDL
     * - default: true
     * - documentation: Whether incremental updates can be specified for updates Default is ' true'.
     * @var bool
     */
    public $HasIncrementalUpdates;
    /**
     * Constructor method for SubscriptionPolicy
     * @uses SubscriptionPolicy::setHasIncrementalUpdates()
     * @param bool $hasIncrementalUpdates
     */
    public function __construct($hasIncrementalUpdates = true)
    {
        $this
            ->setHasIncrementalUpdates($hasIncrementalUpdates);
    }
    /**
     * Get HasIncrementalUpdates value
     * @return bool|null
     */
    public function getHasIncrementalUpdates()
    {
        return $this->HasIncrementalUpdates;
    }
    /**
     * Set HasIncrementalUpdates value
     * @param bool $hasIncrementalUpdates
     * @return \StructType\SubscriptionPolicy
     */
    public function setHasIncrementalUpdates($hasIncrementalUpdates = true)
    {
        // validation for constraint: boolean
        if (!is_null($hasIncrementalUpdates) && !is_bool($hasIncrementalUpdates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasIncrementalUpdates)), __LINE__);
        }
        $this->HasIncrementalUpdates = $hasIncrementalUpdates;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubscriptionPolicy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
